/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.export;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignReadNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLoadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMForeignReadNode.class)
public final class LLVMForeignReadNodeGen
extends LLVMForeignReadNode {
    private static final Uncached UNCACHED = new Uncached();
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @Node.Child
    private ValueData value_cache;

    private LLVMForeignReadNodeGen() {
    }

    @Override
    @ExplodeLoop
    public Object execute(LLVMPointer arg0Value, LLVMInteropType arg1Value) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 1) != 0 && arg1Value instanceof LLVMInteropType.Structured) {
                LLVMInteropType.Structured arg1Value_ = (LLVMInteropType.Structured)arg1Value;
                return LLVMForeignReadNode.doStructured(arg0Value, arg1Value_);
            }
            if ((state & 2) != 0 && arg1Value instanceof LLVMInteropType.Value) {
                LLVMInteropType.Value arg1Value_ = (LLVMInteropType.Value)arg1Value;
                ValueData s2_ = this.value_cache;
                while (s2_ != null) {
                    if (arg1Value_.getKind() == s2_.cachedKind_) {
                        return LLVMForeignReadNode.doValue(arg0Value, arg1Value_, s2_.cachedKind_, s2_.load_, s2_.dataEscape_);
                    }
                    s2_ = s2_.next_;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value);
    }

    private Object executeAndSpecialize(LLVMPointer arg0Value, LLVMInteropType arg1Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (arg1Value instanceof LLVMInteropType.Structured) {
                LLVMInteropType.Structured arg1Value_ = (LLVMInteropType.Structured)arg1Value;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                Object object = LLVMForeignReadNode.doStructured(arg0Value, arg1Value_);
                return object;
            }
            if (arg1Value instanceof LLVMInteropType.Value) {
                LLVMInteropType.Value arg1Value_ = (LLVMInteropType.Value)arg1Value;
                int count2_ = 0;
                ValueData s2_ = this.value_cache;
                if ((state & 2) != 0) {
                    while (s2_ != null && arg1Value_.getKind() != s2_.cachedKind_) {
                        s2_ = s2_.next_;
                        ++count2_;
                    }
                }
                if (s2_ == null) {
                    LLVMInteropType.ValueKind cachedKind__ = arg1Value_.getKind();
                    if (arg1Value_.getKind() == cachedKind__ && count2_ < LLVMForeignReadNode.VALUE_KIND_COUNT) {
                        s2_ = (ValueData)super.insert((Node)new ValueData(this.value_cache));
                        s2_.cachedKind_ = cachedKind__;
                        s2_.load_ = s2_.insertAccessor(LLVMLoadNode.create(cachedKind__));
                        s2_.dataEscape_ = s2_.insertAccessor(LLVMDataEscapeNode.create(cachedKind__.foreignToLLVMType));
                        this.value_cache = s2_;
                        this.state_ = state |= 2;
                    }
                }
                if (s2_ != null) {
                    lock.unlock();
                    hasLock = false;
                    Object object = LLVMForeignReadNode.doValue(arg0Value, arg1Value_, s2_.cachedKind_, s2_.load_, s2_.dataEscape_);
                    return object;
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        ValueData s2_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s2_ = this.value_cache) == null || s2_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMForeignReadNode create() {
        return new LLVMForeignReadNodeGen();
    }

    public static LLVMForeignReadNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=LLVMForeignReadNode.class)
    private static final class Uncached
    extends LLVMForeignReadNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object execute(LLVMPointer arg0Value, LLVMInteropType arg1Value) {
            LLVMInteropType.Value arg1Value_;
            if (arg1Value instanceof LLVMInteropType.Structured) {
                LLVMInteropType.Structured arg1Value_2 = (LLVMInteropType.Structured)arg1Value;
                return LLVMForeignReadNode.doStructured(arg0Value, arg1Value_2);
            }
            if (arg1Value instanceof LLVMInteropType.Value && (arg1Value_ = (LLVMInteropType.Value)arg1Value).getKind() == arg1Value_.getKind()) {
                return LLVMForeignReadNode.doValue(arg0Value, arg1Value_, arg1Value_.getKind(), LLVMLoadNode.getUncached(arg1Value_.getKind()), LLVMDataEscapeNode.getUncached(arg1Value_.getKind().foreignToLLVMType));
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=LLVMForeignReadNode.class)
    private static final class ValueData
    extends Node {
        @Node.Child
        ValueData next_;
        @CompilerDirectives.CompilationFinal
        LLVMInteropType.ValueKind cachedKind_;
        @Node.Child
        LLVMLoadNode load_;
        @Node.Child
        LLVMDataEscapeNode dataEscape_;

        ValueData(ValueData next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

