/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.library.internal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibraryDefaults;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@GeneratedBy(value=LLVMNativeLibraryDefaults.ArrayLibrary.class)
final class ArrayLibraryGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private ArrayLibraryGen() {
    }

    static {
        LibraryExport.register(LLVMNativeLibraryDefaults.ArrayLibrary.class, (LibraryExport[])new LibraryExport[]{new LLVMNativeLibraryExports()});
    }

    @GeneratedBy(value=LLVMNativeLibraryDefaults.ArrayLibrary.class)
    private static final class LLVMNativeLibraryExports
    extends LibraryExport<LLVMNativeLibrary> {
        private static final Uncached UNCACHED = new Uncached();
        private static final Cached CACHE = new Cached();

        private LLVMNativeLibraryExports() {
            super(LLVMNativeLibrary.class, int[].class, true);
        }

        protected LLVMNativeLibrary createUncached(Object receiver) {
            assert (receiver instanceof int[]);
            Uncached uncached = UNCACHED;
            return uncached;
        }

        protected LLVMNativeLibrary createCached(Object receiver) {
            assert (receiver instanceof int[]);
            return CACHE;
        }

        @GeneratedBy(value=LLVMNativeLibraryDefaults.ArrayLibrary.class)
        private static final class Uncached
        extends LLVMNativeLibrary {
            Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof int[]) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof int[];
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isPointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return LLVMNativeLibraryDefaults.ArrayLibrary.isPointer((int[])receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return LLVMNativeLibraryDefaults.ArrayLibrary.asPointer((int[])receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public LLVMNativePointer toNativePointer(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                int[] arg0Value = (int[])arg0Value_;
                return LLVMNativeLibraryDefaults.ArrayLibrary.toNativePointer(arg0Value, this);
            }
        }

        @GeneratedBy(value=LLVMNativeLibraryDefaults.ArrayLibrary.class)
        private static final class Cached
        extends LLVMNativeLibrary {
            Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof int[]) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof int[];
            }

            public boolean isAdoptable() {
                return false;
            }

            @Override
            public boolean isPointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return LLVMNativeLibraryDefaults.ArrayLibrary.isPointer((int[])receiver);
            }

            @Override
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return LLVMNativeLibraryDefaults.ArrayLibrary.asPointer((int[])receiver);
            }

            @Override
            public LLVMNativePointer toNativePointer(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                int[] arg0Value = (int[])arg0Value_;
                Cached self__ = this;
                return LLVMNativeLibraryDefaults.ArrayLibrary.toNativePointer(arg0Value, self__);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }
        }
    }
}

