/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.memory;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.except.LLVMMemoryException;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.function.IntBinaryOperator;
import java.util.function.LongBinaryOperator;
import org.graalvm.collections.EconomicMap;
import sun.misc.Unsafe;

public final class LLVMNativeMemory
extends LLVMMemory {
    private static final int HANDLE_OBJECT_SIZE_BITS = 30;
    private static final long HANDLE_OBJECT_SIZE = 0x40000000L;
    private static final int HANDLE_OBJECT_ADDRESS_BITS = 32;
    private static final long HANDLE_HEADER_MASK = -4611686018427387904L;
    private static final long HANDLE_OFFSET_MASK = 0x3FFFFFFFL;
    private static final long HANDLE_SPACE_START = Long.MIN_VALUE;
    private static final long HANDLE_SPACE_END = -4611686018427387904L;
    private static final long DEREF_HANDLE_SPACE_START = -4611686018427387904L;
    private static final long DEREF_HANDLE_SPACE_END = 0L;
    private static final Unsafe unsafe;
    private static final LLVMNativeMemory INSTANCE;

    private static Unsafe getUnsafe() {
        CompilerAsserts.neverPartOfCompilation();
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            return (Unsafe)theUnsafe.get(null);
        }
        catch (Exception e) {
            throw new AssertionError();
        }
    }

    @Deprecated
    public static LLVMNativeMemory getInstance() {
        return INSTANCE;
    }

    private LLVMNativeMemory() {
    }

    private static boolean checkPointer(long ptr) {
        assert (ptr > 0x100000L) : "trying to access invalid address: " + ptr + " 0x" + Long.toHexString(ptr);
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    private static void memsetBoundary(long address, long size, byte value) {
        unsafe.setMemory(address, size, value);
    }

    @Override
    @Deprecated
    public void memset(Node location, LLVMNativePointer address, long size, byte value) {
        assert (size == 0L || LLVMNativeMemory.checkPointer(address.asNative()));
        try {
            LLVMNativeMemory.memsetBoundary(address.asNative(), size, value);
        }
        catch (Throwable e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static void copyMemoryBoundary(long sourceAddress, long targetAddress, long length) {
        unsafe.copyMemory(sourceAddress, targetAddress, length);
    }

    @Override
    @Deprecated
    @CompilerDirectives.TruffleBoundary
    public void copyMemory(Node location, long sourceAddress, long targetAddress, long length) {
        assert (length == 0L || LLVMNativeMemory.checkPointer(sourceAddress) && LLVMNativeMemory.checkPointer(targetAddress));
        LLVMNativeMemory.copyMemoryBoundary(sourceAddress, targetAddress, length);
    }

    @CompilerDirectives.TruffleBoundary
    private static void freeBoundary(long address) {
        unsafe.freeMemory(address);
    }

    @Override
    public void free(Node location, long address) {
        try {
            LLVMNativeMemory.freeBoundary(address);
        }
        catch (Throwable e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static long allocateMemoryBoundary(long size) {
        return unsafe.allocateMemory(size);
    }

    @Override
    public LLVMNativePointer allocateMemory(Node location, long size) {
        try {
            return LLVMNativePointer.create(LLVMNativeMemory.allocateMemoryBoundary(size));
        }
        catch (Throwable e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static long reallocateMemoryBoundary(long addr, long size) {
        return unsafe.reallocateMemory(addr, size);
    }

    @Override
    @Deprecated
    public LLVMNativePointer reallocateMemory(Node location, LLVMNativePointer addr, long size) {
        try {
            return LLVMNativePointer.create(LLVMNativeMemory.reallocateMemoryBoundary(addr.asNative(), size));
        }
        catch (Throwable e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
    }

    @Override
    public boolean getI1(Node location, long ptr) {
        assert (LLVMNativeMemory.checkPointer(ptr));
        return unsafe.getByte(ptr) != 0;
    }

    @Override
    public byte getI8(Node location, long ptr) {
        assert (LLVMNativeMemory.checkPointer(ptr));
        return unsafe.getByte(ptr);
    }

    @Override
    public short getI16(Node location, long ptr) {
        assert (LLVMNativeMemory.checkPointer(ptr));
        return unsafe.getShort(ptr);
    }

    @Override
    public int getI32(Node location, long ptr) {
        assert (LLVMNativeMemory.checkPointer(ptr));
        return unsafe.getInt(ptr);
    }

    @Override
    public LLVMIVarBit getIVarBit(Node location, LLVMNativePointer addr, int bitWidth) {
        if (bitWidth % 8 != 0) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError();
        }
        int bytes = bitWidth / 8;
        byte[] loadedBytes = new byte[bytes];
        long currentAddressPtr = addr.asNative();
        for (int i = loadedBytes.length - 1; i >= 0; --i) {
            loadedBytes[i] = this.getI8(location, currentAddressPtr);
            ++currentAddressPtr;
        }
        return LLVMIVarBit.create(bitWidth, loadedBytes, bitWidth, false);
    }

    @Override
    public long getI64(Node location, long ptr) {
        assert (LLVMNativeMemory.checkPointer(ptr));
        return unsafe.getLong(ptr);
    }

    @Override
    public float getFloat(Node location, long ptr) {
        assert (LLVMNativeMemory.checkPointer(ptr));
        return unsafe.getFloat(ptr);
    }

    @Override
    public double getDouble(Node location, long ptr) {
        assert (LLVMNativeMemory.checkPointer(ptr));
        return unsafe.getDouble(ptr);
    }

    @Override
    public LLVM80BitFloat get80BitFloat(Node location, LLVMNativePointer addr) {
        byte[] bytes = new byte[10];
        long currentPtr = addr.asNative();
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = this.getI8(location, currentPtr);
            ++currentPtr;
        }
        return LLVM80BitFloat.fromBytes(bytes);
    }

    @Override
    public LLVMNativePointer getPointer(Node location, long ptr) {
        assert (LLVMNativeMemory.checkPointer(ptr));
        return LLVMNativePointer.create(unsafe.getAddress(ptr));
    }

    @Override
    public void putI1(Node location, long ptr, boolean value) {
        assert (LLVMNativeMemory.checkPointer(ptr));
        unsafe.putByte(ptr, (byte)(value ? 1 : 0));
    }

    @Override
    public void putI8(Node location, long ptr, byte value) {
        assert (LLVMNativeMemory.checkPointer(ptr));
        unsafe.putByte(ptr, value);
    }

    @Override
    public void putI16(Node location, long ptr, short value) {
        assert (LLVMNativeMemory.checkPointer(ptr));
        unsafe.putShort(ptr, value);
    }

    @Override
    public void putI32(Node location, long ptr, int value) {
        assert (LLVMNativeMemory.checkPointer(ptr));
        unsafe.putInt(ptr, value);
    }

    @Override
    public void putI64(Node location, long ptr, long value) {
        assert (LLVMNativeMemory.checkPointer(ptr));
        unsafe.putLong(ptr, value);
    }

    @Override
    public void putIVarBit(Node location, LLVMNativePointer addr, LLVMIVarBit value) {
        byte[] bytes = value.getBytes();
        long currentptr = addr.asNative();
        for (int i = bytes.length - 1; i >= 0; --i) {
            this.putI8(location, currentptr, bytes[i]);
            ++currentptr;
        }
    }

    @Override
    public void putByteArray(Node location, long ptr, byte[] bytes) {
        long currentptr = ptr;
        for (int i = 0; i < bytes.length; ++i) {
            this.putI8(location, currentptr, bytes[i]);
            ++currentptr;
        }
    }

    @Override
    public void putFloat(Node location, long ptr, float value) {
        assert (LLVMNativeMemory.checkPointer(ptr));
        unsafe.putFloat(ptr, value);
    }

    @Override
    public void putDouble(Node location, long ptr, double value) {
        assert (LLVMNativeMemory.checkPointer(ptr));
        unsafe.putDouble(ptr, value);
    }

    @Override
    public void put80BitFloat(Node location, long ptr, LLVM80BitFloat value) {
        this.putByteArray(location, ptr, value.getBytes());
    }

    @Override
    public void putPointer(Node location, long ptr, long ptrValue) {
        assert (ptr != 0L);
        unsafe.putAddress(ptr, ptrValue);
    }

    @Override
    public LLVMMemory.CMPXCHGI32 compareAndSwapI32(Node location, LLVMNativePointer p, int comparisonValue, int newValue) {
        boolean b;
        int t;
        assert (LLVMNativeMemory.checkPointer(p.asNative()));
        do {
            if (!CompilerDirectives.injectBranchProbability((double)0.75, (boolean)(b = unsafe.compareAndSwapInt(null, p.asNative(), comparisonValue, newValue)))) continue;
            return new LLVMMemory.CMPXCHGI32(comparisonValue, b);
        } while (CompilerDirectives.injectBranchProbability((double)0.25, ((t = unsafe.getIntVolatile(null, p.asNative())) == comparisonValue ? 1 : 0) != 0));
        return new LLVMMemory.CMPXCHGI32(t, b);
    }

    @Override
    public LLVMMemory.CMPXCHGI64 compareAndSwapI64(Node location, LLVMNativePointer p, long comparisonValue, long newValue) {
        boolean b;
        long t;
        assert (LLVMNativeMemory.checkPointer(p.asNative()));
        do {
            if (!CompilerDirectives.injectBranchProbability((double)0.75, (boolean)(b = unsafe.compareAndSwapLong(null, p.asNative(), comparisonValue, newValue)))) continue;
            return new LLVMMemory.CMPXCHGI64(comparisonValue, b);
        } while (CompilerDirectives.injectBranchProbability((double)0.25, ((t = unsafe.getLongVolatile(null, p.asNative())) == comparisonValue ? 1 : 0) != 0));
        return new LLVMMemory.CMPXCHGI64(t, b);
    }

    private static long alignToI32(long address) {
        long mask = 3L;
        return address & (mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private static int getI8Index(long address) {
        long mask = 3L;
        return (int)(address & mask);
    }

    private static byte getI8At(int value, int index) {
        return (byte)(value >> 8 * index & 0xFF);
    }

    private static int replaceI8(int index, int value, byte replaceByte) {
        return value & ~(255 << index * 8) | (replaceByte & 0xFF) << index * 8;
    }

    @Override
    public LLVMMemory.CMPXCHGI8 compareAndSwapI8(Node location, LLVMNativePointer p, byte comparisonValue, byte newValue) {
        int newVal;
        int t;
        boolean c;
        assert (LLVMNativeMemory.checkPointer(p.asNative()));
        int byteIndex = LLVMNativeMemory.getI8Index(p.asNative());
        long address = LLVMNativeMemory.alignToI32(p.asNative());
        do {
            byte b;
            if (!CompilerDirectives.injectBranchProbability((double)0.75, ((b = LLVMNativeMemory.getI8At(t = unsafe.getIntVolatile(null, address), byteIndex)) != comparisonValue ? 1 : 0) != 0)) continue;
            return new LLVMMemory.CMPXCHGI8(b, false);
        } while (!CompilerDirectives.injectBranchProbability((double)0.75, (boolean)(c = unsafe.compareAndSwapInt(null, address, t, newVal = LLVMNativeMemory.replaceI8(byteIndex, t, newValue)))));
        return new LLVMMemory.CMPXCHGI8(comparisonValue, true);
    }

    private static int getI16Index(long address) {
        long mask = 3L;
        return (int)(address & mask) >> 1;
    }

    private static short getI16At(int value, int index) {
        return (short)(value >> 16 * index & 0xFFFF);
    }

    private static int replaceI16(int index, int value, short replace) {
        return value & ~(65535 << index * 16) | (replace & 0xFFFF) << index * 16;
    }

    @Override
    public LLVMMemory.CMPXCHGI16 compareAndSwapI16(Node location, LLVMNativePointer p, short comparisonValue, short newValue) {
        int newVal;
        int t;
        boolean c;
        assert (LLVMNativeMemory.checkPointer(p.asNative()));
        int idx = LLVMNativeMemory.getI16Index(p.asNative());
        long address = LLVMNativeMemory.alignToI32(p.asNative());
        do {
            short b;
            if (!CompilerDirectives.injectBranchProbability((double)0.75, ((b = LLVMNativeMemory.getI16At(t = unsafe.getIntVolatile(null, address), idx)) != comparisonValue ? 1 : 0) != 0)) continue;
            return new LLVMMemory.CMPXCHGI16(b, false);
        } while (!CompilerDirectives.injectBranchProbability((double)0.75, (boolean)(c = unsafe.compareAndSwapInt(null, address, t, newVal = LLVMNativeMemory.replaceI16(idx, t, newValue)))));
        return new LLVMMemory.CMPXCHGI16(comparisonValue, true);
    }

    @Override
    public long getAndSetI64(Node location, LLVMNativePointer address, long value) {
        assert (LLVMNativeMemory.checkPointer(address.asNative()));
        return unsafe.getAndSetLong(null, address.asNative(), value);
    }

    @Override
    public long getAndAddI64(Node location, LLVMNativePointer address, long value) {
        assert (LLVMNativeMemory.checkPointer(address.asNative()));
        return unsafe.getAndAddLong(null, address.asNative(), value);
    }

    @Override
    public long getAndSubI64(Node location, LLVMNativePointer address, long value) {
        assert (LLVMNativeMemory.checkPointer(address.asNative()));
        return unsafe.getAndAddLong(null, address.asNative(), -value);
    }

    @Override
    public long getAndOpI64(Node location, LLVMNativePointer address, long value, LongBinaryOperator f) {
        long nevv;
        long old;
        assert (LLVMNativeMemory.checkPointer(address.asNative()));
        long addr = address.asNative();
        while (!unsafe.compareAndSwapLong(null, addr, old = this.getI64(location, address), nevv = f.applyAsLong(old, value))) {
        }
        return old;
    }

    @Override
    public int getAndSetI32(Node location, LLVMNativePointer address, int value) {
        assert (LLVMNativeMemory.checkPointer(address.asNative()));
        return unsafe.getAndSetInt(null, address.asNative(), value);
    }

    @Override
    public int getAndAddI32(Node location, LLVMNativePointer address, int value) {
        assert (LLVMNativeMemory.checkPointer(address.asNative()));
        return unsafe.getAndAddInt(null, address.asNative(), value);
    }

    @Override
    public int getAndSubI32(Node location, LLVMNativePointer address, int value) {
        assert (LLVMNativeMemory.checkPointer(address.asNative()));
        return unsafe.getAndAddInt(null, address.asNative(), -value);
    }

    @Override
    public int getAndOpI32(Node location, LLVMNativePointer address, int value, IntBinaryOperator f) {
        int nevv;
        int old;
        assert (LLVMNativeMemory.checkPointer(address.asNative()));
        long addr = address.asNative();
        while (!unsafe.compareAndSwapInt(null, addr, old = this.getI32(location, address), nevv = f.applyAsInt(old, value))) {
        }
        return old;
    }

    @Override
    public short getAndOpI16(Node location, LLVMNativePointer address, short value, LLVMMemory.ShortBinaryOperator f) {
        short nevv;
        short old;
        while (!this.compareAndSwapI16(location, address, old = this.getI16(location, address), nevv = f.apply(old, value)).isSwap()) {
        }
        return old;
    }

    @Override
    public byte getAndOpI8(Node location, LLVMNativePointer address, byte value, LLVMMemory.ByteBinaryOperator f) {
        byte nevv;
        byte old;
        while (!this.compareAndSwapI8(location, address, old = this.getI8(location, address), nevv = f.apply(old, value)).isSwap()) {
        }
        return old;
    }

    @Override
    public boolean getAndOpI1(Node location, LLVMNativePointer address, boolean value, LLVMMemory.BooleanBinaryOperator f) {
        boolean nevv;
        byte old;
        while (!this.compareAndSwapI8(location, address, old, (byte)((nevv = f.apply((old = this.getI8(location, address)) != 0, value)) ? 1 : 0)).isSwap()) {
        }
        return old != 0;
    }

    @Override
    public void fullFence() {
        unsafe.fullFence();
    }

    public static boolean isHandleMemory(long address) {
        return (address & Long.MIN_VALUE) != 0L;
    }

    public static boolean isCommonHandleMemory(long address) {
        return (address & 0xC000000000000000L) == Long.MIN_VALUE;
    }

    public static boolean isDerefHandleMemory(long address) {
        return (address & 0xC000000000000000L) == -4611686018427387904L;
    }

    @Override
    public LLVMMemory.HandleContainer createHandleContainer(boolean deref, Assumption noHandleAssumption) {
        return deref ? new DerefHandleContainer(noHandleAssumption) : new CommonHandleContainer(noHandleAssumption);
    }

    static {
        long tmp = -4611686018427387904L;
        assert (-4611686018427387904L == tmp);
        tmp = Long.MIN_VALUE;
        assert ((0xC000000000000000L & tmp) == Long.MIN_VALUE);
        unsafe = LLVMNativeMemory.getUnsafe();
        INSTANCE = new LLVMNativeMemory();
    }

    private static final class DerefHandleContainer
    extends AbstractHandleContainer {
        DerefHandleContainer(Assumption noHandleAssumption) {
            super(noHandleAssumption);
        }

        @Override
        protected long getStart() {
            return -4611686018427387904L;
        }

        @Override
        protected long getEnd() {
            return 0L;
        }
    }

    private static final class CommonHandleContainer
    extends AbstractHandleContainer {
        CommonHandleContainer(Assumption noHandleAssumption) {
            super(noHandleAssumption);
        }

        @Override
        protected long getStart() {
            return Long.MIN_VALUE;
        }

        @Override
        protected long getEnd() {
            return -4611686018427387904L;
        }
    }

    private static final class Handle {
        private int refcnt = 0;
        private final LLVMNativePointer pointer;
        private final Object managed;

        private Handle(LLVMNativePointer pointer, Object managed) {
            this.pointer = pointer;
            this.managed = managed;
        }
    }

    private static abstract class AbstractHandleContainer
    extends LLVMMemory.HandleContainer {
        private final Assumption noHandleAssumption;
        private final ArrayDeque<Long> freeList = new ArrayDeque();
        private final EconomicMap<Object, Handle> handleFromManaged = EconomicMap.create();
        private Handle[] handleFromPointer = new Handle[1024];
        private long top = this.getStart();

        AbstractHandleContainer(Assumption noHandleAssumption) {
            this.noHandleAssumption = noHandleAssumption;
        }

        protected abstract long getStart();

        protected abstract long getEnd();

        private int indexFromPointer(long address) {
            return (int)(address - this.getStart() >> 30);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public synchronized LLVMNativePointer allocate(Node location, Object value) {
            Handle handle = (Handle)this.handleFromManaged.get(value);
            if (handle == null) {
                long address;
                Long free = this.freeList.pollFirst();
                if (free != null) {
                    address = free;
                } else {
                    this.noHandleAssumption.invalidate();
                    if (this.top >= this.getEnd()) {
                        throw new LLVMMemoryException(location, (Throwable)new OutOfMemoryError("handle space exhausted"));
                    }
                    address = this.top;
                    this.top += 0x40000000L;
                }
                handle = new Handle(LLVMNativePointer.create(address), value);
                int index = this.indexFromPointer(address);
                if (this.handleFromPointer.length <= index) {
                    this.handleFromPointer = Arrays.copyOf(this.handleFromPointer, this.handleFromPointer.length * 2);
                }
                this.handleFromPointer[index] = handle;
                this.handleFromManaged.put(value, (Object)handle);
            }
            handle.refcnt++;
            return handle.pointer;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public synchronized void free(Node location, long address) {
            if ((address & 0x3FFFFFFFL) != 0L) {
                throw new LLVMMemoryException(location, (Throwable)new UnsupportedOperationException("Cannot resolve invalid native handle: " + address));
            }
            if ((address & 0xC000000000000000L) != this.getStart()) {
                throw new LLVMMemoryException(location, (Throwable)new UnsupportedOperationException("Cannot resolve invalid native handle: " + address));
            }
            int index = this.indexFromPointer(address);
            if (index < 0 || index >= this.handleFromPointer.length) {
                throw new LLVMMemoryException(location, (Throwable)new UnsupportedOperationException("Cannot resolve native handle: " + address));
            }
            Handle handle = this.handleFromPointer[index];
            if (handle == null) {
                throw new LLVMMemoryException(location, (Throwable)new UnsupportedOperationException("Cannot resolve native handle (double-free?): " + address));
            }
            if (--handle.refcnt == 0) {
                this.handleFromPointer[index] = null;
                this.handleFromManaged.removeKey(handle.managed);
                this.freeList.addLast(address);
            }
        }

        @Override
        public boolean isHandle(long address) {
            if ((address & 0xC000000000000000L) != this.getStart()) {
                return false;
            }
            int index = this.indexFromPointer(address);
            Handle[] array = this.handleFromPointer;
            return index >= 0 && index < array.length && array[index] != null;
        }

        @Override
        public LLVMManagedPointer getValue(Node location, long address) {
            return LLVMManagedPointer.create(this.handleFromPointer[this.indexFromPointer(address)].managed, address & 0x3FFFFFFFL);
        }
    }
}

