/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.except.LLVMAllocationFailureException;
import com.oracle.truffle.llvm.runtime.except.LLVMStackOverflowError;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;

public abstract class LLVMUniquesRegionAllocNode
extends LLVMNode {
    private final LLVMStack.UniquesRegion.UniquesRegionAllocator allocator;
    @CompilerDirectives.CompilationFinal
    private FrameSlot stackPointer;

    public LLVMUniquesRegionAllocNode(LLVMStack.UniquesRegion.UniquesRegionAllocator allocator) {
        this.allocator = allocator;
    }

    public abstract void execute(VirtualFrame var1);

    protected FrameSlot getStackPointerSlot() {
        if (this.stackPointer == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.stackPointer = this.getRootNode().getFrameDescriptor().findFrameSlot((Object)"<stackpointer>");
        }
        return this.stackPointer;
    }

    @Specialization
    protected void doOp(VirtualFrame frame, @CachedLanguage LLVMLanguage language) {
        try {
            this.allocator.allocate(this, frame, language.getLLVMMemory(), this.getStackPointerSlot());
        }
        catch (LLVMStackOverflowError soe) {
            CompilerDirectives.transferToInterpreter();
            throw new LLVMAllocationFailureException((Node)this, soe);
        }
    }
}

