/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.api;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.base.LLVMFrameNullerUtil;

@NodeInfo(cost=NodeCost.NONE)
public abstract class LLVMFrameNuller
extends LLVMStatementNode {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final FrameSlot[] frameSlots;
    @Node.Child
    private LLVMStatementNode statement;

    public LLVMFrameNuller(FrameSlot[] frameSlots, LLVMStatementNode statement) {
        this.frameSlots = frameSlots;
        this.statement = statement;
    }

    @Override
    public String toString() {
        return this.getShortString("frameSlots");
    }

    @ExplodeLoop
    @Specialization
    public void doExecute(VirtualFrame frame) {
        if (this.statement != null) {
            this.statement.execute(frame);
        }
        for (int i = 0; i < this.frameSlots.length; ++i) {
            LLVMFrameNullerUtil.nullFrameSlot(frame, this.frameSlots[i]);
        }
    }
}

