/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.api;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToPointerNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMToPointerNode.class)
public final class LLVMToPointerNodeGen
extends LLVMToPointerNode {
    private static final Uncached UNCACHED = new Uncached();
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @Node.Child
    private LLVMToNativeNode generic_toNative_;

    private LLVMToPointerNodeGen() {
    }

    @Override
    public LLVMPointer executeWithTarget(Object arg0Value) {
        int state = this.state_;
        if ((state & 1) != 0 && LLVMTypes.isPointer(arg0Value)) {
            LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
            return this.doPointer(arg0Value_);
        }
        if ((state & 2) != 0 && arg0Value instanceof Long) {
            long arg0Value_ = (Long)arg0Value;
            return this.doLong(arg0Value_);
        }
        if ((state & 4) != 0) {
            return this.doGeneric(arg0Value, this.generic_toNative_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LLVMPointer executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if ((exclude & 1) == 0 && LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                LLVMPointer lLVMPointer = this.doPointer(arg0Value_);
                return lLVMPointer;
            }
            if ((exclude & 2) == 0 && arg0Value instanceof Long) {
                long arg0Value_ = (Long)arg0Value;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                LLVMNativePointer lLVMNativePointer = this.doLong(arg0Value_);
                return lLVMNativePointer;
            }
            this.generic_toNative_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNodeGen.create());
            this.exclude_ = exclude |= 3;
            state &= 0xFFFFFFFC;
            this.state_ = state |= 4;
            lock.unlock();
            hasLock = false;
            LLVMPointer lLVMPointer = this.doGeneric(arg0Value, this.generic_toNative_);
            return lLVMPointer;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMToPointerNode create() {
        return new LLVMToPointerNodeGen();
    }

    public static LLVMToPointerNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=LLVMToPointerNode.class)
    private static final class Uncached
    extends LLVMToPointerNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public LLVMPointer executeWithTarget(Object arg0Value) {
            return this.doGeneric(arg0Value, LLVMToNativeNodeGen.getUncached());
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }
}

