/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64AndNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64UpdateFlagsNode;

@GeneratedBy(value=LLVMAMD64AndNode.class)
public final class LLVMAMD64AndNodeFactory {

    @GeneratedBy(value=LLVMAMD64AndNode.LLVMAMD64AndqNode.class)
    public static final class LLVMAMD64AndqNodeGen
    extends LLVMAMD64AndNode.LLVMAMD64AndqNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64AndqNodeGen(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdatePZSFlagsNode flags, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(flags);
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            long rightValue_;
            long leftValue_;
            int state = this.state_;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(frameValue, ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(frameValue, leftValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doI64(frameValue, leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, leftValue_, rightValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) {
            long rightValue_;
            long leftValue_;
            int state = this.state_;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(frameValue, ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(frameValue, leftValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doI64(frameValue, leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, leftValue_, rightValue_);
        }

        private long executeAndSpecialize(VirtualFrame frameValue, Object leftValue, Object rightValue) {
            int state = this.state_;
            if (leftValue instanceof Long) {
                long leftValue_ = (Long)leftValue;
                if (rightValue instanceof Long) {
                    long rightValue_ = (Long)rightValue;
                    this.state_ = state |= 1;
                    return this.doI64(frameValue, leftValue_, rightValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_}, new Object[]{leftValue, rightValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64AndNode.LLVMAMD64AndqNode create(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdatePZSFlagsNode flags, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64AndqNodeGen(flags, left, right);
        }
    }

    @GeneratedBy(value=LLVMAMD64AndNode.LLVMAMD64AndlNode.class)
    public static final class LLVMAMD64AndlNodeGen
    extends LLVMAMD64AndNode.LLVMAMD64AndlNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64AndlNodeGen(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdatePZSFlagsNode flags, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(flags);
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int rightValue_;
            int leftValue_;
            int state = this.state_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(frameValue, ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(frameValue, leftValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doI32(frameValue, leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, leftValue_, rightValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int rightValue_;
            int leftValue_;
            int state = this.state_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(frameValue, ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(frameValue, leftValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doI32(frameValue, leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, leftValue_, rightValue_);
        }

        private int executeAndSpecialize(VirtualFrame frameValue, Object leftValue, Object rightValue) {
            int state = this.state_;
            if (leftValue instanceof Integer) {
                int leftValue_ = (Integer)leftValue;
                if (rightValue instanceof Integer) {
                    int rightValue_ = (Integer)rightValue;
                    this.state_ = state |= 1;
                    return this.doI32(frameValue, leftValue_, rightValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_}, new Object[]{leftValue, rightValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64AndNode.LLVMAMD64AndlNode create(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdatePZSFlagsNode flags, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64AndlNodeGen(flags, left, right);
        }
    }

    @GeneratedBy(value=LLVMAMD64AndNode.LLVMAMD64AndwNode.class)
    public static final class LLVMAMD64AndwNodeGen
    extends LLVMAMD64AndNode.LLVMAMD64AndwNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64AndwNodeGen(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdatePZSFlagsNode flags, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(flags);
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            short rightValue_;
            short leftValue_;
            int state = this.state_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(frameValue, ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(frameValue, leftValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doI16(frameValue, leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, leftValue_, rightValue_);
        }

        @Override
        public short executeI16(VirtualFrame frameValue) {
            short rightValue_;
            short leftValue_;
            int state = this.state_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(frameValue, ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(frameValue, leftValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doI16(frameValue, leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, leftValue_, rightValue_);
        }

        private short executeAndSpecialize(VirtualFrame frameValue, Object leftValue, Object rightValue) {
            int state = this.state_;
            if (leftValue instanceof Short) {
                short leftValue_ = (Short)leftValue;
                if (rightValue instanceof Short) {
                    short rightValue_ = (Short)rightValue;
                    this.state_ = state |= 1;
                    return this.doI16(frameValue, leftValue_, rightValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_}, new Object[]{leftValue, rightValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64AndNode.LLVMAMD64AndwNode create(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdatePZSFlagsNode flags, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64AndwNodeGen(flags, left, right);
        }
    }

    @GeneratedBy(value=LLVMAMD64AndNode.LLVMAMD64AndbNode.class)
    public static final class LLVMAMD64AndbNodeGen
    extends LLVMAMD64AndNode.LLVMAMD64AndbNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64AndbNodeGen(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdatePZSFlagsNode flags, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(flags);
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            byte rightValue_;
            byte leftValue_;
            int state = this.state_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(frameValue, ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(frameValue, leftValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doI8(frameValue, leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, leftValue_, rightValue_);
        }

        @Override
        public byte executeI8(VirtualFrame frameValue) {
            byte rightValue_;
            byte leftValue_;
            int state = this.state_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(frameValue, ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(frameValue, leftValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doI8(frameValue, leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, leftValue_, rightValue_);
        }

        private byte executeAndSpecialize(VirtualFrame frameValue, Object leftValue, Object rightValue) {
            int state = this.state_;
            if (leftValue instanceof Byte) {
                byte leftValue_ = (Byte)leftValue;
                if (rightValue instanceof Byte) {
                    byte rightValue_ = (Byte)rightValue;
                    this.state_ = state |= 1;
                    return this.doI8(frameValue, leftValue_, rightValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_}, new Object[]{leftValue, rightValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64AndNode.LLVMAMD64AndbNode create(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdatePZSFlagsNode flags, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64AndbNodeGen(flags, left, right);
        }
    }
}

