/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64CpuidNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteValueNode;

@GeneratedBy(value=LLVMAMD64CpuidNode.class)
public final class LLVMAMD64CpuidNodeGen
extends LLVMAMD64CpuidNode {
    private LLVMSourceLocation sourceLocation;
    private boolean statement;
    @Node.Child
    private LLVMExpressionNode level_;
    @CompilerDirectives.CompilationFinal
    private int state_;

    private LLVMAMD64CpuidNodeGen(LLVMAMD64WriteValueNode eax, LLVMAMD64WriteValueNode ebx, LLVMAMD64WriteValueNode ecx, LLVMAMD64WriteValueNode edx, LLVMExpressionNode level) {
        super(eax, ebx, ecx, edx);
        this.level_ = level;
    }

    @Override
    public LLVMSourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public void setSourceLocation(LLVMSourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    @Override
    protected boolean isStatement() {
        return this.statement;
    }

    @Override
    protected void setStatement(boolean statement) {
        this.statement = statement;
    }

    @Override
    public void execute(VirtualFrame frameValue) {
        int levelValue_;
        int state = this.state_;
        try {
            levelValue_ = this.level_.executeI32(frameValue);
        }
        catch (UnexpectedResultException ex) {
            this.executeAndSpecialize(frameValue, ex.getResult());
            return;
        }
        if (state != 0) {
            this.doOp(frameValue, levelValue_);
            return;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(frameValue, levelValue_);
    }

    private void executeAndSpecialize(VirtualFrame frameValue, Object levelValue) {
        int state = this.state_;
        if (levelValue instanceof Integer) {
            int levelValue_ = (Integer)levelValue;
            this.state_ = state |= 1;
            this.doOp(frameValue, levelValue_);
            return;
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.level_}, new Object[]{levelValue});
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        return NodeCost.MONOMORPHIC;
    }

    public static LLVMAMD64CpuidNode create(LLVMAMD64WriteValueNode eax, LLVMAMD64WriteValueNode ebx, LLVMAMD64WriteValueNode ecx, LLVMAMD64WriteValueNode edx, LLVMExpressionNode level) {
        return new LLVMAMD64CpuidNodeGen(eax, ebx, ecx, edx, level);
    }
}

