/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64NotNode;

@GeneratedBy(value=LLVMAMD64NotNode.class)
public final class LLVMAMD64NotNodeFactory {

    @GeneratedBy(value=LLVMAMD64NotNode.LLVMAMD64NotqNode.class)
    public static final class LLVMAMD64NotqNodeGen
    extends LLVMAMD64NotNode.LLVMAMD64NotqNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode valueNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64NotqNodeGen(LLVMExpressionNode valueNode) {
            this.valueNode_ = valueNode;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            long valueNodeValue_;
            int state = this.state_;
            try {
                valueNodeValue_ = this.valueNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doI64(valueNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(valueNodeValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) {
            long valueNodeValue_;
            int state = this.state_;
            try {
                valueNodeValue_ = this.valueNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doI64(valueNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(valueNodeValue_);
        }

        private long executeAndSpecialize(Object valueNodeValue) {
            int state = this.state_;
            if (valueNodeValue instanceof Long) {
                long valueNodeValue_ = (Long)valueNodeValue;
                this.state_ = state |= 1;
                return this.doI64(valueNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.valueNode_}, new Object[]{valueNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64NotNode.LLVMAMD64NotqNode create(LLVMExpressionNode valueNode) {
            return new LLVMAMD64NotqNodeGen(valueNode);
        }
    }

    @GeneratedBy(value=LLVMAMD64NotNode.LLVMAMD64NotlNode.class)
    public static final class LLVMAMD64NotlNodeGen
    extends LLVMAMD64NotNode.LLVMAMD64NotlNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode valueNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64NotlNodeGen(LLVMExpressionNode valueNode) {
            this.valueNode_ = valueNode;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int valueNodeValue_;
            int state = this.state_;
            try {
                valueNodeValue_ = this.valueNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doI32(valueNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(valueNodeValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int valueNodeValue_;
            int state = this.state_;
            try {
                valueNodeValue_ = this.valueNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doI32(valueNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(valueNodeValue_);
        }

        private int executeAndSpecialize(Object valueNodeValue) {
            int state = this.state_;
            if (valueNodeValue instanceof Integer) {
                int valueNodeValue_ = (Integer)valueNodeValue;
                this.state_ = state |= 1;
                return this.doI32(valueNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.valueNode_}, new Object[]{valueNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64NotNode.LLVMAMD64NotlNode create(LLVMExpressionNode valueNode) {
            return new LLVMAMD64NotlNodeGen(valueNode);
        }
    }

    @GeneratedBy(value=LLVMAMD64NotNode.LLVMAMD64NotwNode.class)
    public static final class LLVMAMD64NotwNodeGen
    extends LLVMAMD64NotNode.LLVMAMD64NotwNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode valueNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64NotwNodeGen(LLVMExpressionNode valueNode) {
            this.valueNode_ = valueNode;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            short valueNodeValue_;
            int state = this.state_;
            try {
                valueNodeValue_ = this.valueNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doI16(valueNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(valueNodeValue_);
        }

        @Override
        public short executeI16(VirtualFrame frameValue) {
            short valueNodeValue_;
            int state = this.state_;
            try {
                valueNodeValue_ = this.valueNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doI16(valueNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(valueNodeValue_);
        }

        private short executeAndSpecialize(Object valueNodeValue) {
            int state = this.state_;
            if (valueNodeValue instanceof Short) {
                short valueNodeValue_ = (Short)valueNodeValue;
                this.state_ = state |= 1;
                return this.doI16(valueNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.valueNode_}, new Object[]{valueNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64NotNode.LLVMAMD64NotwNode create(LLVMExpressionNode valueNode) {
            return new LLVMAMD64NotwNodeGen(valueNode);
        }
    }

    @GeneratedBy(value=LLVMAMD64NotNode.LLVMAMD64NotbNode.class)
    public static final class LLVMAMD64NotbNodeGen
    extends LLVMAMD64NotNode.LLVMAMD64NotbNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode valueNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64NotbNodeGen(LLVMExpressionNode valueNode) {
            this.valueNode_ = valueNode;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            byte valueNodeValue_;
            int state = this.state_;
            try {
                valueNodeValue_ = this.valueNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doI8(valueNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(valueNodeValue_);
        }

        @Override
        public byte executeI8(VirtualFrame frameValue) {
            byte valueNodeValue_;
            int state = this.state_;
            try {
                valueNodeValue_ = this.valueNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doI8(valueNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(valueNodeValue_);
        }

        private byte executeAndSpecialize(Object valueNodeValue) {
            int state = this.state_;
            if (valueNodeValue instanceof Byte) {
                byte valueNodeValue_ = (Byte)valueNodeValue;
                this.state_ = state |= 1;
                return this.doI8(valueNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.valueNode_}, new Object[]{valueNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64NotNode.LLVMAMD64NotbNode create(LLVMExpressionNode valueNode) {
            return new LLVMAMD64NotbNodeGen(valueNode);
        }
    }
}

