/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64XchgNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteTupelNode;

@GeneratedBy(value=LLVMAMD64XchgNode.class)
public final class LLVMAMD64XchgNodeFactory {

    @GeneratedBy(value=LLVMAMD64XchgNode.LLVMAMD64XchgqNode.class)
    public static final class LLVMAMD64XchgqNodeGen
    extends LLVMAMD64XchgNode.LLVMAMD64XchgqNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64XchgqNodeGen(LLVMAMD64WriteTupelNode out, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(out);
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            long rightValue_;
            long leftValue_;
            int state = this.state_;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, ex.getResult(), rightValue);
                return;
            }
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, leftValue_, ex.getResult());
                return;
            }
            if (state != 0) {
                this.doOp(frameValue, leftValue_, rightValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, leftValue_, rightValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object leftValue, Object rightValue) {
            int state = this.state_;
            if (leftValue instanceof Long) {
                long leftValue_ = (Long)leftValue;
                if (rightValue instanceof Long) {
                    long rightValue_ = (Long)rightValue;
                    this.state_ = state |= 1;
                    this.doOp(frameValue, leftValue_, rightValue_);
                    return;
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_}, new Object[]{leftValue, rightValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64XchgNode.LLVMAMD64XchgqNode create(LLVMAMD64WriteTupelNode out, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64XchgqNodeGen(out, left, right);
        }
    }

    @GeneratedBy(value=LLVMAMD64XchgNode.LLVMAMD64XchglNode.class)
    public static final class LLVMAMD64XchglNodeGen
    extends LLVMAMD64XchgNode.LLVMAMD64XchglNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64XchglNodeGen(LLVMAMD64WriteTupelNode out, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(out);
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int rightValue_;
            int leftValue_;
            int state = this.state_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, ex.getResult(), rightValue);
                return;
            }
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, leftValue_, ex.getResult());
                return;
            }
            if (state != 0) {
                this.doOp(frameValue, leftValue_, rightValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, leftValue_, rightValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object leftValue, Object rightValue) {
            int state = this.state_;
            if (leftValue instanceof Integer) {
                int leftValue_ = (Integer)leftValue;
                if (rightValue instanceof Integer) {
                    int rightValue_ = (Integer)rightValue;
                    this.state_ = state |= 1;
                    this.doOp(frameValue, leftValue_, rightValue_);
                    return;
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_}, new Object[]{leftValue, rightValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64XchgNode.LLVMAMD64XchglNode create(LLVMAMD64WriteTupelNode out, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64XchglNodeGen(out, left, right);
        }
    }

    @GeneratedBy(value=LLVMAMD64XchgNode.LLVMAMD64XchgwNode.class)
    public static final class LLVMAMD64XchgwNodeGen
    extends LLVMAMD64XchgNode.LLVMAMD64XchgwNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64XchgwNodeGen(LLVMAMD64WriteTupelNode out, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(out);
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            short rightValue_;
            short leftValue_;
            int state = this.state_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, ex.getResult(), rightValue);
                return;
            }
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, leftValue_, ex.getResult());
                return;
            }
            if (state != 0) {
                this.doOp(frameValue, leftValue_, rightValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, leftValue_, rightValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object leftValue, Object rightValue) {
            int state = this.state_;
            if (leftValue instanceof Short) {
                short leftValue_ = (Short)leftValue;
                if (rightValue instanceof Short) {
                    short rightValue_ = (Short)rightValue;
                    this.state_ = state |= 1;
                    this.doOp(frameValue, leftValue_, rightValue_);
                    return;
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_}, new Object[]{leftValue, rightValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64XchgNode.LLVMAMD64XchgwNode create(LLVMAMD64WriteTupelNode out, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64XchgwNodeGen(out, left, right);
        }
    }

    @GeneratedBy(value=LLVMAMD64XchgNode.LLVMAMD64XchgbNode.class)
    public static final class LLVMAMD64XchgbNodeGen
    extends LLVMAMD64XchgNode.LLVMAMD64XchgbNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64XchgbNodeGen(LLVMAMD64WriteTupelNode out, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(out);
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            byte rightValue_;
            byte leftValue_;
            int state = this.state_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, ex.getResult(), rightValue);
                return;
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, leftValue_, ex.getResult());
                return;
            }
            if (state != 0) {
                this.doOp(frameValue, leftValue_, rightValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, leftValue_, rightValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object leftValue, Object rightValue) {
            int state = this.state_;
            if (leftValue instanceof Byte) {
                byte leftValue_ = (Byte)leftValue;
                if (rightValue instanceof Byte) {
                    byte rightValue_ = (Byte)rightValue;
                    this.state_ = state |= 1;
                    this.doOp(frameValue, leftValue_, rightValue_);
                    return;
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_}, new Object[]{leftValue, rightValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64XchgNode.LLVMAMD64XchgbNode create(LLVMAMD64WriteTupelNode out, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64XchgbNodeGen(out, left, right);
        }
    }
}

