/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.support;

import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;

@NodeField(name="slot", type=FrameSlot.class)
public abstract class LLVMAMD64ReadRegisterNode
extends LLVMExpressionNode {
    protected abstract FrameSlot getSlot();

    @Specialization(rewriteOn={FrameSlotTypeException.class})
    protected long readI64(VirtualFrame frame) throws FrameSlotTypeException {
        return frame.getLong(this.getSlot());
    }

    @Specialization(replaces={"readI64"}, rewriteOn={FrameSlotTypeException.class})
    protected Object readAddress(VirtualFrame frame) throws FrameSlotTypeException {
        return frame.getObject(this.getSlot());
    }

    @Specialization(replaces={"readI64", "readAddress"})
    protected Object readObject(VirtualFrame frame) {
        return frame.getValue(this.getSlot());
    }
}

