/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.support;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteAddressRegisterNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@GeneratedBy(value=LLVMAMD64WriteAddressRegisterNode.class)
public final class LLVMAMD64WriteAddressRegisterNodeGen
extends LLVMAMD64WriteAddressRegisterNode {
    private LLVMSourceLocation sourceLocation;
    private boolean statement;
    private final FrameSlot slot;
    @Node.Child
    private LLVMExpressionNode value_;
    @CompilerDirectives.CompilationFinal
    private int state_;

    private LLVMAMD64WriteAddressRegisterNodeGen(LLVMExpressionNode value, FrameSlot slot) {
        this.slot = slot;
        this.value_ = value;
    }

    @Override
    public LLVMSourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public void setSourceLocation(LLVMSourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    @Override
    protected boolean isStatement() {
        return this.statement;
    }

    @Override
    protected void setStatement(boolean statement) {
        this.statement = statement;
    }

    @Override
    public FrameSlot getSlot() {
        return this.slot;
    }

    @Override
    public void execute(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 0x1E) == 0 && state != 0) {
            this.execute_byte0(frameValue, state);
            return;
        }
        if ((state & 0x1D) == 0 && state != 0) {
            this.execute_short1(frameValue, state);
            return;
        }
        if ((state & 0x1B) == 0 && state != 0) {
            this.execute_int2(frameValue, state);
            return;
        }
        if ((state & 0x17) == 0 && state != 0) {
            this.execute_long3(frameValue, state);
            return;
        }
        this.execute_generic4(frameValue, state);
    }

    private void execute_byte0(VirtualFrame frameValue, int state) {
        byte valueValue_;
        try {
            valueValue_ = this.value_.executeI8(frameValue);
        }
        catch (UnexpectedResultException ex) {
            this.executeAndSpecialize(frameValue, ex.getResult());
            return;
        }
        assert ((state & 1) != 0);
        this.doI8(frameValue, valueValue_);
    }

    private void execute_short1(VirtualFrame frameValue, int state) {
        short valueValue_;
        try {
            valueValue_ = this.value_.executeI16(frameValue);
        }
        catch (UnexpectedResultException ex) {
            this.executeAndSpecialize(frameValue, ex.getResult());
            return;
        }
        assert ((state & 2) != 0);
        this.doI16(frameValue, valueValue_);
    }

    private void execute_int2(VirtualFrame frameValue, int state) {
        int valueValue_;
        try {
            valueValue_ = this.value_.executeI32(frameValue);
        }
        catch (UnexpectedResultException ex) {
            this.executeAndSpecialize(frameValue, ex.getResult());
            return;
        }
        assert ((state & 4) != 0);
        this.doI32(frameValue, valueValue_);
    }

    private void execute_long3(VirtualFrame frameValue, int state) {
        long valueValue_;
        try {
            valueValue_ = this.value_.executeI64(frameValue);
        }
        catch (UnexpectedResultException ex) {
            this.executeAndSpecialize(frameValue, ex.getResult());
            return;
        }
        assert ((state & 8) != 0);
        this.doI64(frameValue, valueValue_);
    }

    private void execute_generic4(VirtualFrame frameValue, int state) {
        Object valueValue_ = this.value_.executeGeneric(frameValue);
        if ((state & 1) != 0 && valueValue_ instanceof Byte) {
            byte valueValue__ = (Byte)valueValue_;
            this.doI8(frameValue, valueValue__);
            return;
        }
        if ((state & 2) != 0 && valueValue_ instanceof Short) {
            short valueValue__ = (Short)valueValue_;
            this.doI16(frameValue, valueValue__);
            return;
        }
        if ((state & 4) != 0 && valueValue_ instanceof Integer) {
            int valueValue__ = (Integer)valueValue_;
            this.doI32(frameValue, valueValue__);
            return;
        }
        if ((state & 8) != 0 && valueValue_ instanceof Long) {
            long valueValue__ = (Long)valueValue_;
            this.doI64(frameValue, valueValue__);
            return;
        }
        if ((state & 0x10) != 0 && LLVMTypes.isPointer(valueValue_)) {
            LLVMPointer valueValue__ = LLVMTypes.asPointer(valueValue_);
            this.doAddress(frameValue, valueValue__);
            return;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(frameValue, valueValue_);
    }

    private void executeAndSpecialize(VirtualFrame frameValue, Object valueValue) {
        int state = this.state_;
        if (valueValue instanceof Byte) {
            byte valueValue_ = (Byte)valueValue;
            this.state_ = state |= 1;
            this.doI8(frameValue, valueValue_);
            return;
        }
        if (valueValue instanceof Short) {
            short valueValue_ = (Short)valueValue;
            this.state_ = state |= 2;
            this.doI16(frameValue, valueValue_);
            return;
        }
        if (valueValue instanceof Integer) {
            int valueValue_ = (Integer)valueValue;
            this.state_ = state |= 4;
            this.doI32(frameValue, valueValue_);
            return;
        }
        if (valueValue instanceof Long) {
            long valueValue_ = (Long)valueValue;
            this.state_ = state |= 8;
            this.doI64(frameValue, valueValue_);
            return;
        }
        if (LLVMTypes.isPointer(valueValue)) {
            LLVMPointer valueValue_ = LLVMTypes.asPointer(valueValue);
            this.state_ = state |= 0x10;
            this.doAddress(frameValue, valueValue_);
            return;
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.value_}, new Object[]{valueValue});
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMAMD64WriteAddressRegisterNode create(LLVMExpressionNode value, FrameSlot slot) {
        return new LLVMAMD64WriteAddressRegisterNodeGen(value, slot);
    }
}

