/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.support;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMAMD64WriteNode.class)
public final class LLVMAMD64WriteNodeGen
extends LLVMAMD64WriteNode {
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @Node.Child
    private LLVMAMD64WriteNode.LLVMAMD64MemWriteNode memoryWrite_writeNode_;

    private LLVMAMD64WriteNodeGen() {
    }

    private LLVMAMD64WriteNodeGen(int shift) {
        super(shift);
    }

    @Override
    public void execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
        int state = this.state_;
        if ((state & 0x1F) != 0 && arg0Value instanceof FrameSlot) {
            FrameSlot arg0Value_ = (FrameSlot)arg0Value;
            if ((state & 1) != 0 && arg1Value instanceof Byte) {
                byte arg1Value_ = (Byte)arg1Value;
                this.doI8(frameValue, arg0Value_, arg1Value_);
                return;
            }
            if ((state & 2) != 0 && arg1Value instanceof Short) {
                short arg1Value_ = (Short)arg1Value;
                this.doI16(frameValue, arg0Value_, arg1Value_);
                return;
            }
            if ((state & 4) != 0 && arg1Value instanceof Integer) {
                int arg1Value_ = (Integer)arg1Value;
                this.doI32(frameValue, arg0Value_, arg1Value_);
                return;
            }
            if ((state & 8) != 0 && arg1Value instanceof Long) {
                long arg1Value_ = (Long)arg1Value;
                this.doI64(frameValue, arg0Value_, arg1Value_);
                return;
            }
            if ((state & 0x10) != 0 && LLVMTypes.isNativePointer(arg1Value)) {
                LLVMNativePointer arg1Value_ = LLVMTypes.asNativePointer(arg1Value);
                this.doNativePointer(frameValue, arg0Value_, arg1Value_);
                return;
            }
        }
        if ((state & 0x20) != 0 && !LLVMAMD64WriteNode.isFrameSlot(arg0Value)) {
            this.doMemoryWrite(arg0Value, arg1Value, this.memoryWrite_writeNode_);
            return;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
    }

    private void executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (arg0Value instanceof FrameSlot) {
                FrameSlot arg0Value_ = (FrameSlot)arg0Value;
                if (arg1Value instanceof Byte) {
                    byte arg1Value_ = (Byte)arg1Value;
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    this.doI8(frameValue, arg0Value_, arg1Value_);
                    return;
                }
                if (arg1Value instanceof Short) {
                    short arg1Value_ = (Short)arg1Value;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    this.doI16(frameValue, arg0Value_, arg1Value_);
                    return;
                }
                if (arg1Value instanceof Integer) {
                    int arg1Value_ = (Integer)arg1Value;
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    this.doI32(frameValue, arg0Value_, arg1Value_);
                    return;
                }
                if (arg1Value instanceof Long) {
                    long arg1Value_ = (Long)arg1Value;
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    this.doI64(frameValue, arg0Value_, arg1Value_);
                    return;
                }
                if (LLVMTypes.isNativePointer(arg1Value)) {
                    LLVMNativePointer arg1Value_ = LLVMTypes.asNativePointer(arg1Value);
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    this.doNativePointer(frameValue, arg0Value_, arg1Value_);
                    return;
                }
            }
            if (!LLVMAMD64WriteNode.isFrameSlot(arg0Value)) {
                this.memoryWrite_writeNode_ = (LLVMAMD64WriteNode.LLVMAMD64MemWriteNode)super.insert((Node)LLVMAMD64WriteNode.createMemoryWriteNode());
                this.state_ = state |= 0x20;
                lock.unlock();
                hasLock = false;
                this.doMemoryWrite(arg0Value, arg1Value, this.memoryWrite_writeNode_);
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMAMD64WriteNode create() {
        return new LLVMAMD64WriteNodeGen();
    }

    public static LLVMAMD64WriteNode create(int shift) {
        return new LLVMAMD64WriteNodeGen(shift);
    }

    @GeneratedBy(value=LLVMAMD64WriteNode.LLVMAMD64MemWriteNode.class)
    static final class LLVMAMD64MemWriteNodeGen
    extends LLVMAMD64WriteNode.LLVMAMD64MemWriteNode {
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64MemWriteNodeGen() {
        }

        @Override
        public void executeWithTarget(Object arg0Value, Object arg1Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0 && arg1Value instanceof Byte) {
                    byte arg1Value_ = (Byte)arg1Value;
                    this.doI8(arg0Value, arg1Value_);
                    return;
                }
                if ((state & 2) != 0 && arg1Value instanceof Short) {
                    short arg1Value_ = (Short)arg1Value;
                    this.doI16(arg0Value, arg1Value_);
                    return;
                }
                if ((state & 4) != 0 && arg1Value instanceof Integer) {
                    int arg1Value_ = (Integer)arg1Value;
                    this.doI32(arg0Value, arg1Value_);
                    return;
                }
                if ((state & 8) != 0 && arg1Value instanceof Long) {
                    long arg1Value_ = (Long)arg1Value;
                    this.doI64(arg0Value, arg1Value_);
                    return;
                }
                if ((state & 0x10) != 0 && LLVMAMD64MemWriteNodeGen.fallbackGuard_(state, arg0Value, arg1Value)) {
                    this.doObject(arg0Value, arg1Value);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private void executeAndSpecialize(Object arg0Value, Object arg1Value) {
            int state = this.state_;
            if (arg1Value instanceof Byte) {
                byte arg1Value_ = (Byte)arg1Value;
                this.state_ = state |= 1;
                this.doI8(arg0Value, arg1Value_);
                return;
            }
            if (arg1Value instanceof Short) {
                short arg1Value_ = (Short)arg1Value;
                this.state_ = state |= 2;
                this.doI16(arg0Value, arg1Value_);
                return;
            }
            if (arg1Value instanceof Integer) {
                int arg1Value_ = (Integer)arg1Value;
                this.state_ = state |= 4;
                this.doI32(arg0Value, arg1Value_);
                return;
            }
            if (arg1Value instanceof Long) {
                long arg1Value_ = (Long)arg1Value;
                this.state_ = state |= 8;
                this.doI64(arg0Value, arg1Value_);
                return;
            }
            this.state_ = state |= 0x10;
            this.doObject(arg0Value, arg1Value);
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        private static boolean fallbackGuard_(int state, Object arg0Value, Object arg1Value) {
            if ((state & 1) == 0 && arg1Value instanceof Byte) {
                return false;
            }
            if ((state & 2) == 0 && arg1Value instanceof Short) {
                return false;
            }
            if ((state & 4) == 0 && arg1Value instanceof Integer) {
                return false;
            }
            return (state & 8) != 0 || !(arg1Value instanceof Long);
        }

        public static LLVMAMD64WriteNode.LLVMAMD64MemWriteNode create() {
            return new LLVMAMD64MemWriteNodeGen();
        }
    }
}

