/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.base;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.GenerateWrapper;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMControlFlowNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.base.LLVMBasicBlockNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.base.LLVMBasicBlockNodeWrapper;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;
import org.graalvm.options.OptionValues;

@GenerateWrapper
public abstract class LLVMBasicBlockNode
extends LLVMStatementNode {
    public static final int RETURN_FROM_FUNCTION = -1;
    private final int blockId;
    private final String blockName;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public FrameSlot[] nullableBefore;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public FrameSlot[] nullableAfter;

    public static LLVMBasicBlockNode createBasicBlockNode(OptionValues options, LLVMStatementNode[] statements, LLVMControlFlowNode termInstruction, int blockId, String blockName) {
        if (((Boolean)options.get(SulongEngineOption.LAZY_PARSING)).booleanValue()) {
            return LLVMBasicBlockNodeFactory.LazyBlockNodeGen.create(statements, termInstruction, blockId, blockName);
        }
        return LLVMBasicBlockNodeFactory.InitializedBlockNodeGen.create(statements, termInstruction, blockId, blockName);
    }

    public LLVMBasicBlockNode(int blockId, String blockName) {
        this.blockId = blockId;
        this.blockName = blockName;
    }

    protected LLVMBasicBlockNode(LLVMBasicBlockNode other) {
        this.blockId = other.blockId;
        this.blockName = other.blockName;
    }

    @Override
    public InstrumentableNode.WrapperNode createWrapper(ProbeNode probeNode) {
        return new LLVMBasicBlockNodeWrapper(this, this, probeNode);
    }

    public void setNullableFrameSlots(FrameSlot[] nullableBefore, FrameSlot[] nullableAfter) {
        this.nullableBefore = nullableBefore;
        this.nullableAfter = nullableAfter;
    }

    public abstract LLVMBasicBlockNode initialize();

    public abstract LLVMStatementNode[] getStatements();

    @Override
    public abstract void execute(VirtualFrame var1);

    public abstract LLVMControlFlowNode getTerminatingInstruction();

    public int getBlockId() {
        return this.blockId;
    }

    public String getBlockName() {
        return this.blockName;
    }

    public abstract double getBranchProbability(int var1);

    public abstract void increaseBranchProbability(int var1);

    @Override
    public String toString() {
        return this.getShortString("blockId", "nullableBefore", "nullableAfter");
    }

    @Override
    protected abstract boolean isStatement();

    @Override
    protected abstract void setStatement(boolean var1);

    static abstract class LazyBlock
    extends LLVMBasicBlockNode {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final LLVMStatementNode[] statements;
        private final LLVMControlFlowNode termInstruction;

        LazyBlock(LLVMStatementNode[] statements, LLVMControlFlowNode termInstruction, int blockId, String blockName) {
            super(blockId, blockName);
            this.statements = statements;
            this.termInstruction = termInstruction;
        }

        @Override
        public void setNullableFrameSlots(FrameSlot[] nullableBefore, FrameSlot[] nullableAfter) {
            this.nullableBefore = nullableBefore;
            this.nullableAfter = nullableAfter;
        }

        @Override
        public LLVMBasicBlockNode initialize() {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            InitializedBlock materializedBlock = LLVMBasicBlockNodeFactory.InitializedBlockNodeGen.create(this.statements, this.termInstruction, this.getBlockId(), this.getBlockName());
            materializedBlock.setNullableFrameSlots(this.nullableBefore, this.nullableAfter);
            materializedBlock.setSourceLocation(this.getSourceLocation());
            materializedBlock.setHasStatementTag(this.hasStatementTag());
            this.replace(materializedBlock, "Lazily Inserting LLVM Basic Block");
            this.notifyInserted(materializedBlock);
            return materializedBlock;
        }

        @Override
        public final LLVMStatementNode[] getStatements() {
            return this.statements;
        }

        @Specialization
        public void doFail() {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException("Lazy block should have been materialized");
        }

        @Override
        public LLVMControlFlowNode getTerminatingInstruction() {
            return this.termInstruction;
        }

        @Override
        public double getBranchProbability(int successorIndex) {
            return 0.0;
        }

        @Override
        public void increaseBranchProbability(int successorIndex) {
        }

        @Override
        public String toString() {
            CompilerAsserts.neverPartOfCompilation();
            return String.format("uninitialized basic block %s (#statements: %s, terminating instruction: %s)", new Object[]{this.getBlockId(), this.statements.length, this.termInstruction});
        }
    }

    static abstract class InitializedBlock
    extends LLVMBasicBlockNode {
        private final BranchProfile controlFlowExceptionProfile = BranchProfile.create();
        private final BranchProfile blockEntered = BranchProfile.create();
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final long[] successorExecutionCount;
        @Node.Children
        private final LLVMStatementNode[] statements;
        @Node.Child
        public LLVMControlFlowNode termInstruction;

        InitializedBlock(LLVMStatementNode[] statements, LLVMControlFlowNode termInstruction, int blockId, String blockName) {
            super(blockId, blockName);
            this.successorExecutionCount = termInstruction.needsBranchProfiling() ? new long[termInstruction.getSuccessorCount()] : null;
            this.statements = statements;
            this.termInstruction = termInstruction;
        }

        @Override
        public LLVMBasicBlockNode initialize() {
            return this;
        }

        @Override
        public final LLVMStatementNode[] getStatements() {
            return this.statements;
        }

        @ExplodeLoop
        @Specialization
        public void doBlock(VirtualFrame frame) {
            this.blockEntered.enter();
            for (int i = 0; i < this.statements.length; ++i) {
                LLVMStatementNode statement = this.statements[i];
                try {
                    statement.execute(frame);
                    continue;
                }
                catch (ControlFlowException e) {
                    this.controlFlowExceptionProfile.enter();
                    throw e;
                }
            }
        }

        @Override
        public LLVMControlFlowNode getTerminatingInstruction() {
            return this.termInstruction;
        }

        @Override
        @ExplodeLoop
        public double getBranchProbability(int successorIndex) {
            double successorBranchProbability;
            assert (this.termInstruction.needsBranchProfiling());
            long succCount = 0L;
            long totalExecutionCount = 0L;
            for (int i = 0; i < this.successorExecutionCount.length; ++i) {
                long v = this.successorExecutionCount[i];
                if (successorIndex == i) {
                    succCount = v;
                }
                totalExecutionCount += v;
            }
            if (succCount == 0L) {
                successorBranchProbability = 0.0;
            } else {
                assert (totalExecutionCount > 0L);
                successorBranchProbability = (double)succCount / (double)totalExecutionCount;
            }
            assert (!Double.isNaN(successorBranchProbability) && successorBranchProbability >= 0.0 && successorBranchProbability <= 1.0);
            return successorBranchProbability;
        }

        @Override
        public void increaseBranchProbability(int successorIndex) {
            CompilerAsserts.neverPartOfCompilation();
            if (this.termInstruction.needsBranchProfiling()) {
                this.incrementCountAtIndex(successorIndex);
            }
        }

        private void incrementCountAtIndex(int successorIndex) {
            assert (this.termInstruction.needsBranchProfiling());
            int n = successorIndex;
            this.successorExecutionCount[n] = this.successorExecutionCount[n] + 1L;
        }
    }
}

