/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.LLVMIVarBitLarge;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMTo80BitFloatingNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMTo80BitFloatingNode.class)
public final class LLVMTo80BitFloatingNodeGen
extends LLVMTo80BitFloatingNode {
    private LLVMSourceLocation sourceLocation;
    private boolean statement;
    @Node.Child
    private LLVMExpressionNode fromNode_;
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @Node.Child
    private LLVMToNativeNode toNative_;
    @Node.Child
    private LLVMTo80BitFloatingNode recursive_;

    private LLVMTo80BitFloatingNodeGen(LLVMExpressionNode fromNode) {
        this.fromNode_ = fromNode;
    }

    @Override
    public LLVMSourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public void setSourceLocation(LLVMSourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    @Override
    protected boolean isStatement() {
        return this.statement;
    }

    @Override
    protected void setStatement(boolean statement) {
        this.statement = statement;
    }

    @Override
    protected LLVM80BitFloat executeWith(long fromNodeValue) {
        throw CompilerDirectives.shouldNotReachHere((String)"Delegation failed.");
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state = this.state_;
        Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
        if (state != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
            LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
            return this.doPointer(fromNodeValue__, this.toNative_, this.recursive_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(fromNodeValue_);
    }

    private LLVM80BitFloat executeAndSpecialize(Object fromNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (LLVMTypes.isPointer(fromNodeValue)) {
                LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                this.toNative_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNode.createToNativeWithTarget());
                this.recursive_ = (LLVMTo80BitFloatingNode)super.insert((Node)this.createRecursive());
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                LLVM80BitFloat lLVM80BitFloat = this.doPointer(fromNodeValue_, this.toNative_, this.recursive_);
                return lLVM80BitFloat;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        return NodeCost.MONOMORPHIC;
    }

    public static LLVMTo80BitFloatingNode create(LLVMExpressionNode fromNode) {
        return new LLVMTo80BitFloatingNodeGen(fromNode);
    }

    @GeneratedBy(value=LLVMTo80BitFloatingNode.LLVMBitcastToLLVM80BitFloatNode.class)
    public static final class LLVMBitcastToLLVM80BitFloatNodeGen
    extends LLVMTo80BitFloatingNode.LLVMBitcastToLLVM80BitFloatNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private LLVMToNativeNode pointer_toNative_;
        @Node.Child
        private LLVMTo80BitFloatingNode pointer_recursive_;

        private LLVMBitcastToLLVM80BitFloatNodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        protected LLVM80BitFloat executeWith(long fromNodeValue) {
            throw CompilerDirectives.shouldNotReachHere((String)"Delegation failed.");
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0x7D) == 0 && state != 0) {
                return this.executeGeneric_double0(frameValue, state);
            }
            return this.executeGeneric_generic1(frameValue, state);
        }

        private Object executeGeneric_double0(VirtualFrame frameValue, int state) {
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_generic1(VirtualFrame frameValue, int state) {
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state & 1) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                return this.doPointer(fromNodeValue__, this.pointer_toNative_, this.pointer_recursive_);
            }
            if ((state & 2) != 0 && fromNodeValue_ instanceof Double) {
                double fromNodeValue__ = (Double)fromNodeValue_;
                return this.doDouble(fromNodeValue__);
            }
            if ((state & 4) != 0 && fromNodeValue_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat)fromNodeValue_;
                return this.doLLVM80BitFloatNode(fromNodeValue__);
            }
            if ((state & 8) != 0 && LLVMTypes.isLLVMIVarBitLarge(fromNodeValue_)) {
                LLVMIVarBitLarge fromNodeValue__ = LLVMTypes.asLLVMIVarBitLarge(fromNodeValue_);
                return this.doIVarBit(fromNodeValue__);
            }
            if ((state & 0x10) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                return this.doI1Vector(fromNodeValue__);
            }
            if ((state & 0x20) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                return this.doI8Vector(fromNodeValue__);
            }
            if ((state & 0x40) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                return this.doI16Vector(fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVM80BitFloat executeAndSpecialize(Object fromNodeValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (LLVMTypes.isPointer(fromNodeValue)) {
                    LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                    this.pointer_toNative_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNode.createToNativeWithTarget());
                    this.pointer_recursive_ = (LLVMTo80BitFloatingNode)super.insert((Node)this.createRecursive());
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    LLVM80BitFloat lLVM80BitFloat = this.doPointer(fromNodeValue_, this.pointer_toNative_, this.pointer_recursive_);
                    return lLVM80BitFloat;
                }
                if (fromNodeValue instanceof Double) {
                    double fromNodeValue_ = (Double)fromNodeValue;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    LLVM80BitFloat lLVM80BitFloat = this.doDouble(fromNodeValue_);
                    return lLVM80BitFloat;
                }
                if (fromNodeValue instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue_ = (LLVM80BitFloat)fromNodeValue;
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    LLVM80BitFloat lLVM80BitFloat = this.doLLVM80BitFloatNode(fromNodeValue_);
                    return lLVM80BitFloat;
                }
                if (LLVMTypes.isLLVMIVarBitLarge(fromNodeValue)) {
                    LLVMIVarBitLarge fromNodeValue_ = LLVMTypes.asLLVMIVarBitLarge(fromNodeValue);
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    LLVM80BitFloat lLVM80BitFloat = this.doIVarBit(fromNodeValue_);
                    return lLVM80BitFloat;
                }
                if (fromNodeValue instanceof LLVMI1Vector) {
                    LLVMI1Vector fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    LLVM80BitFloat lLVM80BitFloat = this.doI1Vector(fromNodeValue_);
                    return lLVM80BitFloat;
                }
                if (fromNodeValue instanceof LLVMI8Vector) {
                    LLVMI8Vector fromNodeValue_ = (LLVMI8Vector)fromNodeValue;
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    LLVM80BitFloat lLVM80BitFloat = this.doI8Vector(fromNodeValue_);
                    return lLVM80BitFloat;
                }
                if (fromNodeValue instanceof LLVMI16Vector) {
                    LLVMI16Vector fromNodeValue_ = (LLVMI16Vector)fromNodeValue;
                    this.state_ = state |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    LLVM80BitFloat lLVM80BitFloat = this.doI16Vector(fromNodeValue_);
                    return lLVM80BitFloat;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMTo80BitFloatingNode.LLVMBitcastToLLVM80BitFloatNode create(LLVMExpressionNode fromNode) {
            return new LLVMBitcastToLLVM80BitFloatNodeGen(fromNode);
        }
    }

    @GeneratedBy(value=LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode.class)
    public static final class LLVMUnsignedCastToLLVM80BitFloatNodeGen
    extends LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private LLVMToNativeNode pointer_toNative_;
        @Node.Child
        private LLVMTo80BitFloatingNode pointer_recursive_;

        private LLVMUnsignedCastToLLVM80BitFloatNodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        protected LLVM80BitFloat executeWith(long fromNodeValue) {
            int state = this.state_;
            if ((state & 0x20) != 0) {
                return this.doLLVM80BitFloatNode(fromNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0x3FD) == 0 && state != 0) {
                return this.executeGeneric_boolean0(frameValue, state);
            }
            if ((state & 0x3FB) == 0 && state != 0) {
                return this.executeGeneric_byte1(frameValue, state);
            }
            if ((state & 0x3F7) == 0 && state != 0) {
                return this.executeGeneric_short2(frameValue, state);
            }
            if ((state & 0x3EF) == 0 && state != 0) {
                return this.executeGeneric_int3(frameValue, state);
            }
            if ((state & 0x3DF) == 0 && state != 0) {
                return this.executeGeneric_long4(frameValue, state);
            }
            if ((state & 0x3BF) == 0 && state != 0) {
                return this.executeGeneric_float5(frameValue, state);
            }
            if ((state & 0x37F) == 0 && state != 0) {
                return this.executeGeneric_double6(frameValue, state);
            }
            return this.executeGeneric_generic7(frameValue, state);
        }

        private Object executeGeneric_boolean0(VirtualFrame frameValue, int state) {
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doLLVM80BitFloatNode(fromNodeValue_);
        }

        private Object executeGeneric_byte1(VirtualFrame frameValue, int state) {
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 4) != 0);
            return this.do80BitFloat(fromNodeValue_);
        }

        private Object executeGeneric_short2(VirtualFrame frameValue, int state) {
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 8) != 0);
            return this.do80BitFloat(fromNodeValue_);
        }

        private Object executeGeneric_int3(VirtualFrame frameValue, int state) {
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x10) != 0);
            return this.doLLVM80BitFloatNode(fromNodeValue_);
        }

        private Object executeGeneric_long4(VirtualFrame frameValue, int state) {
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x20) != 0);
            return this.doLLVM80BitFloatNode(fromNodeValue_);
        }

        private Object executeGeneric_float5(VirtualFrame frameValue, int state) {
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x40) != 0);
            return this.doLLVM80BitFloatNode(fromNodeValue_);
        }

        private Object executeGeneric_double6(VirtualFrame frameValue, int state) {
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x80) != 0);
            return this.doLLVM80BitFloatNode(fromNodeValue_);
        }

        private Object executeGeneric_generic7(VirtualFrame frameValue, int state) {
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state & 1) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                return this.doPointer(fromNodeValue__, this.pointer_toNative_, this.pointer_recursive_);
            }
            if ((state & 2) != 0 && fromNodeValue_ instanceof Boolean) {
                boolean fromNodeValue__ = (Boolean)fromNodeValue_;
                return this.doLLVM80BitFloatNode(fromNodeValue__);
            }
            if ((state & 4) != 0 && fromNodeValue_ instanceof Byte) {
                byte fromNodeValue__ = (Byte)fromNodeValue_;
                return this.do80BitFloat(fromNodeValue__);
            }
            if ((state & 8) != 0 && fromNodeValue_ instanceof Short) {
                short fromNodeValue__ = (Short)fromNodeValue_;
                return this.do80BitFloat(fromNodeValue__);
            }
            if ((state & 0x10) != 0 && fromNodeValue_ instanceof Integer) {
                int fromNodeValue__ = (Integer)fromNodeValue_;
                return this.doLLVM80BitFloatNode(fromNodeValue__);
            }
            if ((state & 0x20) != 0 && fromNodeValue_ instanceof Long) {
                long fromNodeValue__ = (Long)fromNodeValue_;
                return this.doLLVM80BitFloatNode(fromNodeValue__);
            }
            if ((state & 0x40) != 0 && fromNodeValue_ instanceof Float) {
                float fromNodeValue__ = ((Float)fromNodeValue_).floatValue();
                return this.doLLVM80BitFloatNode(fromNodeValue__);
            }
            if ((state & 0x80) != 0 && fromNodeValue_ instanceof Double) {
                double fromNodeValue__ = (Double)fromNodeValue_;
                return this.doLLVM80BitFloatNode(fromNodeValue__);
            }
            if ((state & 0x100) != 0 && fromNodeValue_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat)fromNodeValue_;
                return this.doLLVM80BitFloatNode(fromNodeValue__);
            }
            if ((state & 0x200) != 0 && LLVMTypes.isLLVMIVarBitLarge(fromNodeValue_)) {
                LLVMIVarBitLarge fromNodeValue__ = LLVMTypes.asLLVMIVarBitLarge(fromNodeValue_);
                return this.doLLVM80BitFloatNode(fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVM80BitFloat executeAndSpecialize(Object fromNodeValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (LLVMTypes.isPointer(fromNodeValue)) {
                    LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                    this.pointer_toNative_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNode.createToNativeWithTarget());
                    this.pointer_recursive_ = (LLVMTo80BitFloatingNode)super.insert((Node)this.createRecursive());
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    LLVM80BitFloat lLVM80BitFloat = this.doPointer(fromNodeValue_, this.pointer_toNative_, this.pointer_recursive_);
                    return lLVM80BitFloat;
                }
                if (fromNodeValue instanceof Boolean) {
                    boolean fromNodeValue_ = (Boolean)fromNodeValue;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    LLVM80BitFloat lLVM80BitFloat = this.doLLVM80BitFloatNode(fromNodeValue_);
                    return lLVM80BitFloat;
                }
                if (fromNodeValue instanceof Byte) {
                    byte fromNodeValue_ = (Byte)fromNodeValue;
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    LLVM80BitFloat lLVM80BitFloat = this.do80BitFloat(fromNodeValue_);
                    return lLVM80BitFloat;
                }
                if (fromNodeValue instanceof Short) {
                    short fromNodeValue_ = (Short)fromNodeValue;
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    LLVM80BitFloat lLVM80BitFloat = this.do80BitFloat(fromNodeValue_);
                    return lLVM80BitFloat;
                }
                if (fromNodeValue instanceof Integer) {
                    int fromNodeValue_ = (Integer)fromNodeValue;
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    LLVM80BitFloat lLVM80BitFloat = this.doLLVM80BitFloatNode(fromNodeValue_);
                    return lLVM80BitFloat;
                }
                if (fromNodeValue instanceof Long) {
                    long fromNodeValue_ = (Long)fromNodeValue;
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    LLVM80BitFloat lLVM80BitFloat = this.doLLVM80BitFloatNode(fromNodeValue_);
                    return lLVM80BitFloat;
                }
                if (fromNodeValue instanceof Float) {
                    float fromNodeValue_ = ((Float)fromNodeValue).floatValue();
                    this.state_ = state |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    LLVM80BitFloat lLVM80BitFloat = this.doLLVM80BitFloatNode(fromNodeValue_);
                    return lLVM80BitFloat;
                }
                if (fromNodeValue instanceof Double) {
                    double fromNodeValue_ = (Double)fromNodeValue;
                    this.state_ = state |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    LLVM80BitFloat lLVM80BitFloat = this.doLLVM80BitFloatNode(fromNodeValue_);
                    return lLVM80BitFloat;
                }
                if (fromNodeValue instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue_ = (LLVM80BitFloat)fromNodeValue;
                    this.state_ = state |= 0x100;
                    lock.unlock();
                    hasLock = false;
                    LLVM80BitFloat lLVM80BitFloat = this.doLLVM80BitFloatNode(fromNodeValue_);
                    return lLVM80BitFloat;
                }
                if (LLVMTypes.isLLVMIVarBitLarge(fromNodeValue)) {
                    LLVMIVarBitLarge fromNodeValue_ = LLVMTypes.asLLVMIVarBitLarge(fromNodeValue);
                    this.state_ = state |= 0x200;
                    lock.unlock();
                    hasLock = false;
                    LLVM80BitFloat lLVM80BitFloat = this.doLLVM80BitFloatNode(fromNodeValue_);
                    return lLVM80BitFloat;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMTo80BitFloatingNode.LLVMUnsignedCastToLLVM80BitFloatNode create(LLVMExpressionNode fromNode) {
            return new LLVMUnsignedCastToLLVM80BitFloatNodeGen(fromNode);
        }
    }

    @GeneratedBy(value=LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode.class)
    public static final class LLVMSignedCastToLLVM80BitFloatNodeGen
    extends LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private LLVMToNativeNode pointer_toNative_;
        @Node.Child
        private LLVMTo80BitFloatingNode pointer_recursive_;

        private LLVMSignedCastToLLVM80BitFloatNodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        protected LLVM80BitFloat executeWith(long fromNodeValue) {
            int state = this.state_;
            if ((state & 0x20) != 0) {
                return this.doLLVM80BitFloatNode(fromNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0x3FD) == 0 && state != 0) {
                return this.executeGeneric_boolean0(frameValue, state);
            }
            if ((state & 0x3FB) == 0 && state != 0) {
                return this.executeGeneric_byte1(frameValue, state);
            }
            if ((state & 0x3F7) == 0 && state != 0) {
                return this.executeGeneric_short2(frameValue, state);
            }
            if ((state & 0x3EF) == 0 && state != 0) {
                return this.executeGeneric_int3(frameValue, state);
            }
            if ((state & 0x3DF) == 0 && state != 0) {
                return this.executeGeneric_long4(frameValue, state);
            }
            if ((state & 0x3BF) == 0 && state != 0) {
                return this.executeGeneric_float5(frameValue, state);
            }
            if ((state & 0x37F) == 0 && state != 0) {
                return this.executeGeneric_double6(frameValue, state);
            }
            return this.executeGeneric_generic7(frameValue, state);
        }

        private Object executeGeneric_boolean0(VirtualFrame frameValue, int state) {
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doLLVM80BitFloatNode(fromNodeValue_);
        }

        private Object executeGeneric_byte1(VirtualFrame frameValue, int state) {
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 4) != 0);
            return this.do80BitFloat(fromNodeValue_);
        }

        private Object executeGeneric_short2(VirtualFrame frameValue, int state) {
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 8) != 0);
            return this.doLLVM80BitFloatNode(fromNodeValue_);
        }

        private Object executeGeneric_int3(VirtualFrame frameValue, int state) {
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x10) != 0);
            return this.doLLVM80BitFloatNode(fromNodeValue_);
        }

        private Object executeGeneric_long4(VirtualFrame frameValue, int state) {
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x20) != 0);
            return this.doLLVM80BitFloatNode(fromNodeValue_);
        }

        private Object executeGeneric_float5(VirtualFrame frameValue, int state) {
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x40) != 0);
            return this.doLLVM80BitFloatNode(fromNodeValue_);
        }

        private Object executeGeneric_double6(VirtualFrame frameValue, int state) {
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x80) != 0);
            return this.doLLVM80BitFloatNode(fromNodeValue_);
        }

        private Object executeGeneric_generic7(VirtualFrame frameValue, int state) {
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state & 1) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                return this.doPointer(fromNodeValue__, this.pointer_toNative_, this.pointer_recursive_);
            }
            if ((state & 2) != 0 && fromNodeValue_ instanceof Boolean) {
                boolean fromNodeValue__ = (Boolean)fromNodeValue_;
                return this.doLLVM80BitFloatNode(fromNodeValue__);
            }
            if ((state & 4) != 0 && fromNodeValue_ instanceof Byte) {
                byte fromNodeValue__ = (Byte)fromNodeValue_;
                return this.do80BitFloat(fromNodeValue__);
            }
            if ((state & 8) != 0 && fromNodeValue_ instanceof Short) {
                short fromNodeValue__ = (Short)fromNodeValue_;
                return this.doLLVM80BitFloatNode(fromNodeValue__);
            }
            if ((state & 0x10) != 0 && fromNodeValue_ instanceof Integer) {
                int fromNodeValue__ = (Integer)fromNodeValue_;
                return this.doLLVM80BitFloatNode(fromNodeValue__);
            }
            if ((state & 0x20) != 0 && fromNodeValue_ instanceof Long) {
                long fromNodeValue__ = (Long)fromNodeValue_;
                return this.doLLVM80BitFloatNode(fromNodeValue__);
            }
            if ((state & 0x40) != 0 && fromNodeValue_ instanceof Float) {
                float fromNodeValue__ = ((Float)fromNodeValue_).floatValue();
                return this.doLLVM80BitFloatNode(fromNodeValue__);
            }
            if ((state & 0x80) != 0 && fromNodeValue_ instanceof Double) {
                double fromNodeValue__ = (Double)fromNodeValue_;
                return this.doLLVM80BitFloatNode(fromNodeValue__);
            }
            if ((state & 0x100) != 0 && fromNodeValue_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat)fromNodeValue_;
                return this.doLLVM80BitFloatNode(fromNodeValue__);
            }
            if ((state & 0x200) != 0 && LLVMTypes.isLLVMIVarBitLarge(fromNodeValue_)) {
                LLVMIVarBitLarge fromNodeValue__ = LLVMTypes.asLLVMIVarBitLarge(fromNodeValue_);
                return this.doLLVM80BitFloatNode(fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVM80BitFloat executeAndSpecialize(Object fromNodeValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (LLVMTypes.isPointer(fromNodeValue)) {
                    LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                    this.pointer_toNative_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNode.createToNativeWithTarget());
                    this.pointer_recursive_ = (LLVMTo80BitFloatingNode)super.insert((Node)this.createRecursive());
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    LLVM80BitFloat lLVM80BitFloat = this.doPointer(fromNodeValue_, this.pointer_toNative_, this.pointer_recursive_);
                    return lLVM80BitFloat;
                }
                if (fromNodeValue instanceof Boolean) {
                    boolean fromNodeValue_ = (Boolean)fromNodeValue;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    LLVM80BitFloat lLVM80BitFloat = this.doLLVM80BitFloatNode(fromNodeValue_);
                    return lLVM80BitFloat;
                }
                if (fromNodeValue instanceof Byte) {
                    byte fromNodeValue_ = (Byte)fromNodeValue;
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    LLVM80BitFloat lLVM80BitFloat = this.do80BitFloat(fromNodeValue_);
                    return lLVM80BitFloat;
                }
                if (fromNodeValue instanceof Short) {
                    short fromNodeValue_ = (Short)fromNodeValue;
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    LLVM80BitFloat lLVM80BitFloat = this.doLLVM80BitFloatNode(fromNodeValue_);
                    return lLVM80BitFloat;
                }
                if (fromNodeValue instanceof Integer) {
                    int fromNodeValue_ = (Integer)fromNodeValue;
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    LLVM80BitFloat lLVM80BitFloat = this.doLLVM80BitFloatNode(fromNodeValue_);
                    return lLVM80BitFloat;
                }
                if (fromNodeValue instanceof Long) {
                    long fromNodeValue_ = (Long)fromNodeValue;
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    LLVM80BitFloat lLVM80BitFloat = this.doLLVM80BitFloatNode(fromNodeValue_);
                    return lLVM80BitFloat;
                }
                if (fromNodeValue instanceof Float) {
                    float fromNodeValue_ = ((Float)fromNodeValue).floatValue();
                    this.state_ = state |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    LLVM80BitFloat lLVM80BitFloat = this.doLLVM80BitFloatNode(fromNodeValue_);
                    return lLVM80BitFloat;
                }
                if (fromNodeValue instanceof Double) {
                    double fromNodeValue_ = (Double)fromNodeValue;
                    this.state_ = state |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    LLVM80BitFloat lLVM80BitFloat = this.doLLVM80BitFloatNode(fromNodeValue_);
                    return lLVM80BitFloat;
                }
                if (fromNodeValue instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue_ = (LLVM80BitFloat)fromNodeValue;
                    this.state_ = state |= 0x100;
                    lock.unlock();
                    hasLock = false;
                    LLVM80BitFloat lLVM80BitFloat = this.doLLVM80BitFloatNode(fromNodeValue_);
                    return lLVM80BitFloat;
                }
                if (LLVMTypes.isLLVMIVarBitLarge(fromNodeValue)) {
                    LLVMIVarBitLarge fromNodeValue_ = LLVMTypes.asLLVMIVarBitLarge(fromNodeValue);
                    this.state_ = state |= 0x200;
                    lock.unlock();
                    hasLock = false;
                    LLVM80BitFloat lLVM80BitFloat = this.doLLVM80BitFloatNode(fromNodeValue_);
                    return lLVM80BitFloat;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMTo80BitFloatingNode.LLVMSignedCastToLLVM80BitFloatNode create(LLVMExpressionNode fromNode) {
            return new LLVMSignedCastToLLVM80BitFloatNodeGen(fromNode);
        }
    }
}

