/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToI64Node;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;

@NodeChild(value="fromNode", type=LLVMExpressionNode.class)
public abstract class LLVMToI16Node
extends LLVMExpressionNode {
    @Specialization(guards={"isForeignNumber(from, foreigns, interop)"})
    protected short doManagedPointer(LLVMManagedPointer from, @Cached(value="createForeignToLLVM()") ForeignToLLVM toLLVM, @CachedLibrary(limit="1") LLVMAsForeignLibrary foreigns, @CachedLibrary(limit="3") InteropLibrary interop) {
        return (Short)toLLVM.executeWithTarget(foreigns.asForeign(from.getObject()));
    }

    @Specialization
    protected short doPointer(LLVMPointer from, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode toNative) {
        return (short)toNative.executeWithTarget(from).asNative();
    }

    protected ForeignToLLVM createForeignToLLVM() {
        return CommonNodeFactory.createForeignToLLVM(ForeignToLLVM.ForeignToLLVMType.I16);
    }

    protected static boolean isForeignNumber(LLVMManagedPointer pointer, LLVMAsForeignLibrary foreigns, InteropLibrary interop) {
        return foreigns.isForeign(pointer) && interop.isNumber(pointer.getObject());
    }

    public static abstract class LLVMBitcastToI16Node
    extends LLVMToI16Node {
        @Specialization
        protected short doI16(short from) {
            return from;
        }

        @Specialization
        protected short doI1Vector(LLVMI1Vector from) {
            return (short)LLVMToI64Node.LLVMBitcastToI64Node.castI1Vector(from, 16);
        }

        @Specialization
        protected short doI8Vector(LLVMI8Vector from) {
            return (short)LLVMToI64Node.LLVMBitcastToI64Node.castI8Vector(from, 2);
        }

        @Specialization
        protected short doI16Vector(LLVMI16Vector from) {
            assert (from.getLength() == 1) : "invalid vector size";
            return from.getValue(0);
        }
    }

    public static abstract class LLVMUnsignedCastToI16Node
    extends LLVMToI16Node {
        @Specialization
        protected short doI1(boolean from) {
            return (short)(from ? 1 : 0);
        }

        @Specialization
        protected short doI8(byte from) {
            return (short)(from & 0xFF);
        }

        @Specialization
        protected short doI16(short from) {
            return from;
        }

        @Specialization
        protected short doIVarBit(LLVMIVarBit from) {
            return from.getZeroExtendedShortValue();
        }

        @Specialization
        protected short doFloat(float from) {
            return (short)from;
        }

        @Specialization
        protected short doDouble(double from) {
            return (short)from;
        }

        @Specialization
        protected short doLLVM80BitFloat(LLVM80BitFloat from) {
            return from.getShortValue();
        }
    }

    public static abstract class LLVMSignedCastToI16Node
    extends LLVMToI16Node {
        @Specialization
        protected short doI16(boolean from) {
            return (short)(from ? -1 : 0);
        }

        @Specialization
        protected short doI16(byte from) {
            return from;
        }

        @Specialization
        protected short doLLVMFunction(short from) {
            return from;
        }

        @Specialization
        protected short doI16(int from) {
            return (short)from;
        }

        @Specialization
        protected short doI16(long from) {
            return (short)from;
        }

        @Specialization
        protected short doI16(float from) {
            return (short)from;
        }

        @Specialization
        protected short doI16(double from) {
            return (short)from;
        }

        @Specialization
        protected short doLLVM80BitFloat(LLVM80BitFloat from) {
            return from.getShortValue();
        }

        @Specialization
        protected short doI16(LLVMIVarBit from) {
            return from.getShortValue();
        }
    }
}

