/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.control;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.NodeFields;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.GenerateWrapper;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMControlFlowNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMConditionalBranchNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMConditionalBranchNodeWrapper;

@GenerateWrapper
@NodeFields(value={@NodeField(name="trueSuccessor", type=int.class), @NodeField(name="falseSuccessor", type=int.class)})
@NodeChild(value="condition", type=LLVMExpressionNode.class)
public abstract class LLVMConditionalBranchNode
extends LLVMControlFlowNode {
    public static final int TRUE_SUCCESSOR = 0;
    public static final int FALSE_SUCCESSOR = 1;

    public static LLVMConditionalBranchNode create(int trueSuccessor, int falseSuccessor, LLVMStatementNode truePhi, LLVMStatementNode falsePhi, LLVMExpressionNode condition) {
        return LLVMConditionalBranchNodeFactory.LLVMConditionalBranchNodeImplNodeGen.create(truePhi, falsePhi, condition, trueSuccessor, falseSuccessor);
    }

    public InstrumentableNode.WrapperNode createWrapper(ProbeNode probe) {
        return new LLVMConditionalBranchNodeWrapper(this, probe);
    }

    public abstract boolean executeCondition(VirtualFrame var1);

    public abstract int getTrueSuccessor();

    public abstract int getFalseSuccessor();

    @Override
    protected abstract boolean isStatement();

    @Override
    protected abstract void setStatement(boolean var1);

    static abstract class LLVMConditionalBranchNodeImpl
    extends LLVMConditionalBranchNode {
        @Node.Child
        private LLVMStatementNode truePhi;
        @Node.Child
        private LLVMStatementNode falsePhi;

        LLVMConditionalBranchNodeImpl(LLVMStatementNode truePhi, LLVMStatementNode falsePhi) {
            this.truePhi = truePhi;
            this.falsePhi = falsePhi;
        }

        @Override
        public String toString() {
            return this.getShortString("trueSuccessor", "falseSuccessor");
        }

        @Override
        public int getSuccessorCount() {
            return 2;
        }

        @Override
        public LLVMStatementNode getPhiNode(int successorIndex) {
            CompilerAsserts.partialEvaluationConstant((int)successorIndex);
            if (successorIndex == 0) {
                return this.truePhi;
            }
            assert (successorIndex == 1);
            return this.falsePhi;
        }

        @Specialization
        public boolean doCondition(boolean condition) {
            return condition;
        }

        @Override
        public int[] getSuccessors() {
            return new int[]{this.getTrueSuccessor(), this.getFalseSuccessor()};
        }
    }
}

