/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.control;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.vars.LLVMWriteNode;

public abstract class LLVMWritePhisNode
extends LLVMStatementNode {
    @Node.Children
    private final LLVMExpressionNode[] cycleFrom;
    @Node.Children
    private final LLVMWriteNode[] cycleWrites;
    @Node.Children
    private final LLVMWriteNode[] ordinaryWrites;

    public LLVMWritePhisNode(LLVMExpressionNode[] cycleFrom, LLVMWriteNode[] cycleWrites, LLVMWriteNode[] ordinaryWrites) {
        this.ordinaryWrites = ordinaryWrites;
        this.cycleFrom = cycleFrom;
        this.cycleWrites = cycleWrites;
        assert (cycleFrom.length == cycleWrites.length);
    }

    @Specialization
    void doWritePhis(VirtualFrame frame) {
        if (this.cycleFrom.length == 0) {
            this.writeOrdinaryValues(frame);
        } else {
            Object[] values = this.readCycleValues(frame);
            this.writeOrdinaryValues(frame);
            this.writeCycleValues(frame, values);
        }
    }

    @ExplodeLoop
    private Object[] readCycleValues(VirtualFrame frame) {
        Object[] result = new Object[this.cycleFrom.length];
        for (int i = 0; i < this.cycleFrom.length; ++i) {
            result[i] = this.cycleFrom[i].executeGeneric(frame);
        }
        return result;
    }

    @ExplodeLoop
    private void writeCycleValues(VirtualFrame frame, Object[] values) {
        for (int i = 0; i < this.cycleWrites.length; ++i) {
            this.cycleWrites[i].executeWithTarget(frame, values[i]);
        }
    }

    @ExplodeLoop
    private void writeOrdinaryValues(VirtualFrame frame) {
        for (int i = 0; i < this.ordinaryWrites.length; ++i) {
            this.ordinaryWrites[i].execute(frame);
        }
    }
}

