/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.GenerateWrapper;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMControlFlowNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMDispatchNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMDispatchNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMInvokeNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMInvokeNodeWrapper;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMLookupDispatchTargetNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMLookupDispatchTargetNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMValueProfilingNode;
import com.oracle.truffle.llvm.runtime.nodes.vars.LLVMWriteNode;
import com.oracle.truffle.llvm.runtime.types.FunctionType;

@GenerateWrapper
public abstract class LLVMInvokeNode
extends LLVMControlFlowNode {
    public static final int NORMAL_SUCCESSOR = 0;
    public static final int UNWIND_SUCCESSOR = 1;

    public static LLVMInvokeNode create(FunctionType type, LLVMWriteNode writeResult, LLVMExpressionNode functionNode, LLVMExpressionNode[] argumentNodes, int normalSuccessor, int unwindSuccessor, LLVMStatementNode normalPhiNode, LLVMStatementNode unwindPhiNode) {
        LLVMLookupDispatchTargetNode dispatchTargetNode = LLVMLookupDispatchTargetNodeGen.create(functionNode);
        return LLVMInvokeNodeFactory.LLVMInvokeNodeImplNodeGen.create(type, writeResult, argumentNodes, normalSuccessor, unwindSuccessor, normalPhiNode, unwindPhiNode, dispatchTargetNode);
    }

    public InstrumentableNode.WrapperNode createWrapper(ProbeNode probe) {
        return new LLVMInvokeNodeWrapper(this, probe);
    }

    public abstract int getNormalSuccessor();

    public abstract int getUnwindSuccessor();

    public abstract void execute(VirtualFrame var1);

    @Override
    public boolean needsBranchProfiling() {
        return false;
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == StandardTags.CallTag.class) {
            return this.getSourceLocation() != null;
        }
        return super.hasTag(tag);
    }

    @Override
    protected abstract boolean isStatement();

    @Override
    protected abstract void setStatement(boolean var1);

    @NodeChild(value="dispatchTarget", type=LLVMLookupDispatchTargetNode.class)
    static abstract class LLVMInvokeNodeImpl
    extends LLVMInvokeNode {
        @Node.Child
        protected LLVMStatementNode normalPhiNode;
        @Node.Child
        protected LLVMStatementNode unwindPhiNode;
        @Node.Child
        protected LLVMValueProfilingNode returnValueProfile;
        @Node.Children
        private final LLVMExpressionNode[] argumentNodes;
        @Node.Child
        private LLVMDispatchNode dispatchNode;
        @Node.Child
        private LLVMWriteNode writeResult;
        protected final FunctionType type;
        private final int normalSuccessor;
        private final int unwindSuccessor;

        LLVMInvokeNodeImpl(FunctionType type, LLVMWriteNode writeResult, LLVMExpressionNode[] argumentNodes, int normalSuccessor, int unwindSuccessor, LLVMStatementNode normalPhiNode, LLVMStatementNode unwindPhiNode) {
            this.writeResult = writeResult;
            this.normalSuccessor = normalSuccessor;
            this.unwindSuccessor = unwindSuccessor;
            this.type = type;
            this.normalPhiNode = normalPhiNode;
            this.unwindPhiNode = unwindPhiNode;
            this.returnValueProfile = (LLVMValueProfilingNode)LLVMValueProfilingNode.create(null, type.getReturnType());
            this.argumentNodes = argumentNodes;
            this.dispatchNode = LLVMDispatchNodeGen.create(type);
        }

        @Override
        public int getSuccessorCount() {
            return 2;
        }

        @Override
        public int getNormalSuccessor() {
            return this.normalSuccessor;
        }

        @Override
        public int getUnwindSuccessor() {
            return this.unwindSuccessor;
        }

        @Override
        public int[] getSuccessors() {
            return new int[]{this.normalSuccessor, this.unwindSuccessor};
        }

        @Specialization
        public void doInvoke(VirtualFrame frame, Object function) {
            Object[] argValues = this.prepareArguments(frame);
            Object result = this.dispatchNode.executeDispatch(function, argValues);
            if (this.writeResult != null) {
                this.writeResult.executeWithTarget(frame, result);
            }
        }

        @ExplodeLoop
        private Object[] prepareArguments(VirtualFrame frame) {
            Object[] argValues = new Object[this.argumentNodes.length];
            for (int i = 0; i < this.argumentNodes.length; ++i) {
                argValues[i] = this.argumentNodes[i].executeGeneric(frame);
            }
            return argValues;
        }

        @Override
        public LLVMStatementNode getPhiNode(int successorIndex) {
            if (successorIndex == 0) {
                return this.normalPhiNode;
            }
            assert (successorIndex == 1);
            return this.unwindPhiNode;
        }
    }
}

