/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.memory.LLVMNativeMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@NodeChild(value="function", type=LLVMExpressionNode.class)
public abstract class LLVMLookupDispatchTargetNode
extends LLVMExpressionNode {
    protected static final int INLINE_CACHE_SIZE = 5;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.LanguageReference<LLVMLanguage> languageRef;

    @Specialization(limit="INLINE_CACHE_SIZE", guards={"isSameObject(pointer.getObject(), cachedDescriptor)", "cachedDescriptor != null", "pointer.getOffset() == 0"})
    protected static LLVMFunctionDescriptor doDirectCached(LLVMManagedPointer pointer, @Cached(value="asFunctionDescriptor(pointer.getObject())") LLVMFunctionDescriptor cachedDescriptor) {
        return cachedDescriptor;
    }

    @Specialization(guards={"isFunctionDescriptor(pointer.getObject())", "pointer.getOffset() == 0"}, replaces={"doDirectCached"})
    protected static LLVMFunctionDescriptor doDirect(LLVMManagedPointer pointer) {
        return (LLVMFunctionDescriptor)pointer.getObject();
    }

    @Specialization(guards={"foreigns.isForeign(pointer.getObject())", "pointer.getOffset() == 0"})
    protected Object doForeign(LLVMManagedPointer pointer, @CachedLibrary(limit="3") LLVMAsForeignLibrary foreigns) {
        return pointer.getObject();
    }

    @Specialization(limit="INLINE_CACHE_SIZE", guards={"pointer.asNative() == cachedAddress", "!isAutoDerefHandle(cachedAddress)", "cachedDescriptor != null"})
    protected static LLVMFunctionDescriptor doHandleCached(LLVMNativePointer pointer, @Cached(value="pointer.asNative()") long cachedAddress, @CachedContext(value=LLVMLanguage.class) TruffleLanguage.ContextReference<LLVMContext> ctxRef, @Cached(value="lookupFunction(ctxRef, pointer)") LLVMFunctionDescriptor cachedDescriptor) {
        return cachedDescriptor;
    }

    @Specialization(limit="INLINE_CACHE_SIZE", guards={"pointer.asNative() == cachedAddress", "!isAutoDerefHandle(cachedAddress)", "cachedDescriptor == null"})
    protected static LLVMNativePointer doNativeFunctionCached(LLVMNativePointer pointer, @Cached(value="pointer.asNative()") long cachedAddress, @CachedContext(value=LLVMLanguage.class) TruffleLanguage.ContextReference<LLVMContext> ctxRef, @Cached(value="lookupFunction(ctxRef, pointer)") LLVMFunctionDescriptor cachedDescriptor) {
        return pointer;
    }

    @Specialization(guards={"!isAutoDerefHandle(pointer.asNative())"}, replaces={"doHandleCached", "doNativeFunctionCached"})
    protected Object doLookup(LLVMNativePointer pointer, @CachedContext(value=LLVMLanguage.class) TruffleLanguage.ContextReference<LLVMContext> ctxRef) {
        LLVMFunctionDescriptor descriptor = this.lookupFunction(ctxRef, pointer);
        if (descriptor != null) {
            return descriptor;
        }
        return pointer;
    }

    @Specialization(guards={"isAutoDerefHandle(pointer.asNative())"})
    protected Object doDerefHandle(LLVMNativePointer pointer, @Cached LLVMDerefHandleGetReceiverNode getReceiver) {
        LLVMManagedPointer foreignFunction = getReceiver.execute(pointer);
        return foreignFunction.getObject();
    }

    protected LLVMFunctionDescriptor lookupFunction(TruffleLanguage.ContextReference<LLVMContext> ctxRef, LLVMNativePointer function) {
        return ((LLVMContext)ctxRef.get()).getFunctionDescriptor(function);
    }

    protected boolean isAutoDerefHandle(long addr) {
        if (this.languageRef == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.languageRef = this.lookupLanguageReference(LLVMLanguage.class);
        }
        if (CompilerDirectives.inCompiledCode() && ((LLVMLanguage)this.languageRef.get()).getNoDerefHandleAssumption().isValid()) {
            return false;
        }
        return LLVMNativeMemory.isDerefHandleMemory(addr);
    }
}

