/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.NFIContextExtension;
import com.oracle.truffle.llvm.runtime.interop.nfi.LLVMNativeConvertNode;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMNativeCallUtils;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.types.FunctionType;

public abstract class LLVMNativeDispatchNode
extends LLVMNode {
    private final FunctionType type;
    @CompilerDirectives.CompilationFinal
    private Object identity;
    @Node.Child
    InteropLibrary identityExecute;

    protected LLVMNativeDispatchNode(FunctionType type) {
        this.type = type;
    }

    public abstract Object executeDispatch(Object var1, Object[] var2);

    @CompilerDirectives.TruffleBoundary
    protected TruffleObject identityFunction() {
        String signature;
        LLVMContext context = (LLVMContext)this.lookupContextReference(LLVMLanguage.class).get();
        NFIContextExtension nfiContextExtension = context.getContextExtension(NFIContextExtension.class);
        try {
            signature = nfiContextExtension.getNativeSignature(this.type, 1);
        }
        catch (NFIContextExtension.UnsupportedNativeTypeException e) {
            throw new IllegalStateException(e);
        }
        return nfiContextExtension.getNativeFunction(context, "identity", String.format("(POINTER):%s", signature));
    }

    protected Object dispatchIdentity(long pointer) {
        try {
            if (this.identity == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                if (this.identity == null) {
                    this.identity = this.identityFunction();
                    this.identityExecute = (InteropLibrary)this.insert((Node)((InteropLibrary)InteropLibrary.getFactory().create(this.identity)));
                }
            }
            return this.identityExecute.execute(this.identity, new Object[]{pointer});
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException(e);
        }
    }

    @ExplodeLoop
    protected LLVMNativeConvertNode[] createToNativeNodes() {
        LLVMNativeConvertNode[] ret = new LLVMNativeConvertNode[this.type.getNumberOfArguments() - 1];
        for (int i = 1; i < this.type.getNumberOfArguments(); ++i) {
            ret[i - 1] = LLVMNativeConvertNode.createToNative(this.type.getArgumentType(i));
        }
        return ret;
    }

    protected LLVMNativeConvertNode createFromNativeNode() {
        CompilerAsserts.neverPartOfCompilation();
        return LLVMNativeConvertNode.createFromNative(this.type.getReturnType());
    }

    @ExplodeLoop
    private static Object[] prepareNativeArguments(Object[] arguments, LLVMNativeConvertNode[] toNative) {
        Object[] nativeArgs = new Object[arguments.length - 1];
        for (int i = 1; i < arguments.length; ++i) {
            nativeArgs[i - 1] = toNative[i - 1].executeConvert(arguments[i]);
        }
        return nativeArgs;
    }

    @Specialization(guards={"function.asNative() == cachedFunction.asNative()"})
    protected Object doCached(LLVMNativePointer function, Object[] arguments, @CachedContext(value=LLVMLanguage.class) TruffleLanguage.ContextReference<LLVMContext> context, @Cached(value="function") LLVMNativePointer cachedFunction, @Cached(value="dispatchIdentity(cachedFunction.asNative())") Object nativeFunctionHandle, @CachedLibrary(value="nativeFunctionHandle") InteropLibrary nativeCall, @Cached(value="createToNativeNodes()") LLVMNativeConvertNode[] toNative, @Cached(value="createFromNativeNode()") LLVMNativeConvertNode fromNative, @Cached(value="nativeCallStatisticsEnabled(context)") boolean statistics) {
        Object returnValue;
        Object[] nativeArgs = LLVMNativeDispatchNode.prepareNativeArguments(arguments, toNative);
        try (LLVMStack.StackPointer save = ((LLVMStack.StackPointer)arguments[0]).newFrame();){
            returnValue = LLVMNativeCallUtils.callNativeFunction(statistics, context, nativeCall, nativeFunctionHandle, nativeArgs, null);
        }
        return fromNative.executeConvert(returnValue);
    }

    @Specialization
    protected Object doGeneric(LLVMNativePointer function, Object[] arguments, @CachedContext(value=LLVMLanguage.class) TruffleLanguage.ContextReference<LLVMContext> context, @Cached(value="createToNativeNodes()") LLVMNativeConvertNode[] toNative, @Cached(value="createFromNativeNode()") LLVMNativeConvertNode fromNative, @CachedLibrary(limit="5") InteropLibrary nativeCall, @Cached(value="nativeCallStatisticsEnabled(context)") boolean statistics) {
        Object returnValue;
        Object[] nativeArgs = LLVMNativeDispatchNode.prepareNativeArguments(arguments, toNative);
        try (LLVMStack.StackPointer save = ((LLVMStack.StackPointer)arguments[0]).newFrame();){
            returnValue = LLVMNativeCallUtils.callNativeFunction(statistics, context, nativeCall, this.dispatchIdentity(function.asNative()), nativeArgs, null);
        }
        return fromNative.executeConvert(returnValue);
    }
}

