/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.c;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemMoveNode;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemSetNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.c.LLVMMemIntrinsic;

@GeneratedBy(value=LLVMMemIntrinsic.class)
public final class LLVMMemIntrinsicFactory {

    @GeneratedBy(value=LLVMMemIntrinsic.LLVMLibcMemcpy.class)
    public static final class LLVMLibcMemcpyNodeGen
    extends LLVMMemIntrinsic.LLVMLibcMemcpy {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode dst_;
        @Node.Child
        private LLVMExpressionNode src_;
        @Node.Child
        private LLVMExpressionNode len_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMLibcMemcpyNodeGen(LLVMMemMoveNode memcpy, LLVMExpressionNode dst, LLVMExpressionNode src, LLVMExpressionNode len) {
            super(memcpy);
            this.dst_ = dst;
            this.src_ = src;
            this.len_ = len;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object dstValue_ = this.dst_.executeGeneric(frameValue);
            Object srcValue_ = this.src_.executeGeneric(frameValue);
            if ((state & 2) == 0 && state != 0) {
                return this.executeGeneric_int0(frameValue, state, dstValue_, srcValue_);
            }
            if ((state & 1) == 0 && state != 0) {
                return this.executeGeneric_long1(frameValue, state, dstValue_, srcValue_);
            }
            return this.executeGeneric_generic2(frameValue, state, dstValue_, srcValue_);
        }

        private Object executeGeneric_int0(VirtualFrame frameValue, int state, Object dstValue_, Object srcValue_) {
            int lenValue_;
            try {
                lenValue_ = this.len_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(dstValue_, srcValue_, ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.op(dstValue_, srcValue_, lenValue_);
        }

        private Object executeGeneric_long1(VirtualFrame frameValue, int state, Object dstValue_, Object srcValue_) {
            long lenValue_;
            try {
                lenValue_ = this.len_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(dstValue_, srcValue_, ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.op(dstValue_, srcValue_, lenValue_);
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state, Object dstValue_, Object srcValue_) {
            Object lenValue_ = this.len_.executeGeneric(frameValue);
            if (state != 0) {
                if ((state & 1) != 0 && lenValue_ instanceof Integer) {
                    int lenValue__ = (Integer)lenValue_;
                    return this.op(dstValue_, srcValue_, lenValue__);
                }
                if ((state & 2) != 0 && lenValue_ instanceof Long) {
                    long lenValue__ = (Long)lenValue_;
                    return this.op(dstValue_, srcValue_, lenValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(dstValue_, srcValue_, lenValue_);
        }

        private Object executeAndSpecialize(Object dstValue, Object srcValue, Object lenValue) {
            int state = this.state_;
            if (lenValue instanceof Integer) {
                int lenValue_ = (Integer)lenValue;
                this.state_ = state |= 1;
                return this.op(dstValue, srcValue, lenValue_);
            }
            if (lenValue instanceof Long) {
                long lenValue_ = (Long)lenValue;
                this.state_ = state |= 2;
                return this.op(dstValue, srcValue, lenValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.dst_, this.src_, this.len_}, new Object[]{dstValue, srcValue, lenValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMMemIntrinsic.LLVMLibcMemcpy create(LLVMMemMoveNode memcpy, LLVMExpressionNode dst, LLVMExpressionNode src, LLVMExpressionNode len) {
            return new LLVMLibcMemcpyNodeGen(memcpy, dst, src, len);
        }
    }

    @GeneratedBy(value=LLVMMemIntrinsic.LLVMLibcMemset.class)
    public static final class LLVMLibcMemsetNodeGen
    extends LLVMMemIntrinsic.LLVMLibcMemset {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode dst_;
        @Node.Child
        private LLVMExpressionNode value_;
        @Node.Child
        private LLVMExpressionNode len_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMLibcMemsetNodeGen(LLVMMemSetNode memset, LLVMExpressionNode dst, LLVMExpressionNode value, LLVMExpressionNode len) {
            super(memset);
            this.dst_ = dst;
            this.value_ = value;
            this.len_ = len;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object dstValue_ = this.dst_.executeGeneric(frameValue);
            if ((state & 0xE) == 0 && state != 0) {
                return this.executeGeneric_int_int0(frameValue, state, dstValue_);
            }
            if ((state & 0xD) == 0 && state != 0) {
                return this.executeGeneric_int_long1(frameValue, state, dstValue_);
            }
            if ((state & 0xB) == 0 && state != 0) {
                return this.executeGeneric_byte_int2(frameValue, state, dstValue_);
            }
            if ((state & 7) == 0 && state != 0) {
                return this.executeGeneric_byte_long3(frameValue, state, dstValue_);
            }
            return this.executeGeneric_generic4(frameValue, state, dstValue_);
        }

        private Object executeGeneric_int_int0(VirtualFrame frameValue, int state, Object dstValue_) {
            int lenValue_;
            int valueValue_;
            try {
                valueValue_ = this.value_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object lenValue = this.len_.executeGeneric(frameValue);
                return this.executeAndSpecialize(dstValue_, ex.getResult(), lenValue);
            }
            try {
                lenValue_ = this.len_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(dstValue_, valueValue_, ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.op(dstValue_, valueValue_, lenValue_);
        }

        private Object executeGeneric_int_long1(VirtualFrame frameValue, int state, Object dstValue_) {
            long lenValue_;
            int valueValue_;
            try {
                valueValue_ = this.value_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object lenValue = this.len_.executeGeneric(frameValue);
                return this.executeAndSpecialize(dstValue_, ex.getResult(), lenValue);
            }
            try {
                lenValue_ = this.len_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(dstValue_, valueValue_, ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.op(dstValue_, valueValue_, lenValue_);
        }

        private Object executeGeneric_byte_int2(VirtualFrame frameValue, int state, Object dstValue_) {
            int lenValue_;
            byte valueValue_;
            try {
                valueValue_ = this.value_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object lenValue = this.len_.executeGeneric(frameValue);
                return this.executeAndSpecialize(dstValue_, ex.getResult(), lenValue);
            }
            try {
                lenValue_ = this.len_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(dstValue_, valueValue_, ex.getResult());
            }
            assert ((state & 4) != 0);
            return this.op(dstValue_, valueValue_, lenValue_);
        }

        private Object executeGeneric_byte_long3(VirtualFrame frameValue, int state, Object dstValue_) {
            long lenValue_;
            byte valueValue_;
            try {
                valueValue_ = this.value_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object lenValue = this.len_.executeGeneric(frameValue);
                return this.executeAndSpecialize(dstValue_, ex.getResult(), lenValue);
            }
            try {
                lenValue_ = this.len_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(dstValue_, valueValue_, ex.getResult());
            }
            assert ((state & 8) != 0);
            return this.op(dstValue_, valueValue_, lenValue_);
        }

        private Object executeGeneric_generic4(VirtualFrame frameValue, int state, Object dstValue_) {
            Object valueValue_ = this.value_.executeGeneric(frameValue);
            Object lenValue_ = this.len_.executeGeneric(frameValue);
            if (state != 0) {
                if ((state & 3) != 0 && valueValue_ instanceof Integer) {
                    int n = (Integer)valueValue_;
                    if ((state & 1) != 0 && lenValue_ instanceof Integer) {
                        int lenValue__ = (Integer)lenValue_;
                        return this.op(dstValue_, n, lenValue__);
                    }
                    if ((state & 2) != 0 && lenValue_ instanceof Long) {
                        long lenValue__ = (Long)lenValue_;
                        return this.op(dstValue_, n, lenValue__);
                    }
                }
                if ((state & 0xC) != 0 && valueValue_ instanceof Byte) {
                    byte by = (Byte)valueValue_;
                    if ((state & 4) != 0 && lenValue_ instanceof Integer) {
                        int lenValue__ = (Integer)lenValue_;
                        return this.op(dstValue_, by, lenValue__);
                    }
                    if ((state & 8) != 0 && lenValue_ instanceof Long) {
                        long lenValue__ = (Long)lenValue_;
                        return this.op(dstValue_, by, lenValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(dstValue_, valueValue_, lenValue_);
        }

        private Object executeAndSpecialize(Object dstValue, Object valueValue, Object lenValue) {
            int state = this.state_;
            if (valueValue instanceof Integer) {
                int n = (Integer)valueValue;
                if (lenValue instanceof Integer) {
                    int lenValue_ = (Integer)lenValue;
                    this.state_ = state |= 1;
                    return this.op(dstValue, n, lenValue_);
                }
                if (lenValue instanceof Long) {
                    long lenValue_ = (Long)lenValue;
                    this.state_ = state |= 2;
                    return this.op(dstValue, n, lenValue_);
                }
            }
            if (valueValue instanceof Byte) {
                byte by = (Byte)valueValue;
                if (lenValue instanceof Integer) {
                    int lenValue_ = (Integer)lenValue;
                    this.state_ = state |= 4;
                    return this.op(dstValue, by, lenValue_);
                }
                if (lenValue instanceof Long) {
                    long lenValue_ = (Long)lenValue;
                    this.state_ = state |= 8;
                    return this.op(dstValue, by, lenValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.dst_, this.value_, this.len_}, new Object[]{dstValue, valueValue, lenValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMMemIntrinsic.LLVMLibcMemset create(LLVMMemSetNode memset, LLVMExpressionNode dst, LLVMExpressionNode value, LLVMExpressionNode len) {
            return new LLVMLibcMemsetNodeGen(memset, dst, value, len);
        }
    }
}

