/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.c;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMThread;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import sun.misc.Signal;
import sun.misc.SignalHandler;

@NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class, value="signal"), @NodeChild(type=LLVMExpressionNode.class, value="handler")})
public abstract class LLVMSignal
extends LLVMExpressionNode {
    private static final Lock globalSignalHandlerLock = new ReentrantLock();
    private static final Map<Integer, LLVMSignalHandler> registeredSignals = new HashMap<Integer, LLVMSignalHandler>();

    @Specialization
    protected LLVMPointer doSignal(int signal, LLVMPointer handler, @CachedContext(value=LLVMLanguage.class) LLVMContext context, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode toNative) {
        return LLVMSignal.setSignalHandler(context, signal, toNative.executeWithTarget(handler));
    }

    private static LLVMPointer setSignalHandler(LLVMContext context, int signalId, LLVMNativePointer function) {
        try {
            Signals decodedSignal = Signals.decode(signalId);
            return LLVMSignal.setSignalHandler(context, decodedSignal.signal(), function);
        }
        catch (NoSuchElementException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return context.getSigErr();
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static int getNumberOfRegisteredSignals() {
        return registeredSignals.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private static LLVMPointer setSignalHandler(LLVMContext context, Signal signal, LLVMNativePointer function) {
        int signalId = signal.getNumber();
        LLVMPointer returnFunction = context.getSigDfl();
        try {
            LLVMSignalHandler newSignalHandler = new LLVMSignalHandler(context, signal, function);
            Map<Integer, LLVMSignalHandler> map = registeredSignals;
            synchronized (map) {
                LLVMSignalHandler currentFunction;
                if (registeredSignals.containsKey(signalId) && (currentFunction = registeredSignals.get(signalId)).isRunning()) {
                    returnFunction = currentFunction.getFunction();
                    currentFunction.setStopped();
                }
                registeredSignals.put(signalId, newSignalHandler);
            }
        }
        catch (IllegalArgumentException e) {
            return context.getSigErr();
        }
        return returnFunction;
    }

    private static enum Signals {
        SIG_HUP("HUP"),
        SIG_INT("INT"),
        SIG_QUIT("QUIT"),
        SIG_ILL("ILL"),
        SIG_ABRT("ABRT"),
        SIG_FPE("FPE"),
        SIG_KILL("KILL"),
        SIG_SEGV("SEGV"),
        SIG_PIPE("PIPE"),
        SIG_ALRM("ALRM"),
        SIG_TERM("TERM"),
        SIG_USR1("USR1"),
        SIG_USR2("USR2"),
        SIG_CHLD("CHLD"),
        SIG_CONT("CONT"),
        SIG_STOP("STOP"),
        SIG_TSTP("TSTP"),
        SIG_TTIN("TTIN"),
        SIG_BUS("BUS"),
        SIG_POLL("POLL"),
        SIG_PROF("PROF"),
        SIG_SYS("SYS"),
        SIG_TRAP("TRAP"),
        SIG_URG("URG"),
        SIG_VTALRM("VTALRM"),
        SIG_XCPU("XCPU"),
        SIG_XFSZ("XFSZ"),
        SIG_IOT("IOT"),
        SIG_EMT("EMT"),
        SIG_STKFLT("STKFLT"),
        SIG_IO("IO"),
        SIG_CLD("CLD"),
        SIG_PWR("PWR"),
        SIG_INFO("INFO"),
        SIG_LOST("LOST"),
        SIG_WINCH("WINCH"),
        SIG_UNUSED("UNUSED");

        private static final Signals[] VALUES;
        private final Signal signal;

        @CompilerDirectives.TruffleBoundary
        public static Signals decode(int code) throws NoSuchElementException {
            for (Signals currentSignal : VALUES) {
                if (currentSignal.signal() == null || currentSignal.signal().getNumber() != code) continue;
                return currentSignal;
            }
            throw new NoSuchElementException("signal with the id " + code + " not found");
        }

        private Signals(String signalName) {
            Signal constructedSignal;
            try {
                constructedSignal = new Signal(signalName);
            }
            catch (IllegalArgumentException e) {
                constructedSignal = null;
            }
            this.signal = constructedSignal;
        }

        public Signal signal() {
            return this.signal;
        }

        static {
            VALUES = Signals.values();
        }
    }

    private static final class LLVMSignalHandler
    implements SignalHandler,
    LLVMThread {
        private final Signal signal;
        private final LLVMContext context;
        private final LLVMPointer handler;
        private final Lock lock = new ReentrantLock();
        private final AtomicBoolean isRunning = new AtomicBoolean(false);
        private static final long HANDLE_MAX_WAITING_TIME = 250L;

        @CompilerDirectives.TruffleBoundary
        private LLVMSignalHandler(LLVMContext context, Signal signal, LLVMPointer function) throws IllegalArgumentException {
            this.signal = signal;
            this.context = context;
            this.lock.lock();
            try {
                if (function.isSame(context.getSigDfl())) {
                    this.handler = function;
                    Signal.handle(signal, SignalHandler.SIG_DFL);
                } else if (function.isSame(context.getSigIgn())) {
                    this.handler = function;
                    Signal.handle(signal, SignalHandler.SIG_IGN);
                } else {
                    this.handler = function;
                    Signal.handle(signal, this);
                }
                this.isRunning.set(true);
                context.registerThread(this);
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            finally {
                this.lock.unlock();
            }
        }

        public LLVMPointer getFunction() {
            return this.handler;
        }

        @CompilerDirectives.TruffleBoundary
        public boolean isRunning() {
            return this.isRunning.get();
        }

        @CompilerDirectives.TruffleBoundary
        protected void finalize() throws Throwable {
            super.finalize();
            this.stop();
            this.unregisterFromContext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void handle(Signal arg0) {
            block12: {
                try {
                    if (!globalSignalHandlerLock.tryLock(250L, TimeUnit.MILLISECONDS)) {
                        System.err.println("could not execute signal handler. Sulong can currently only execute one signal at once!");
                        return;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new AssertionError((Object)e);
                }
                this.lock.lock();
                try {
                    if (!this.isRunning.get()) break block12;
                    try {
                        TruffleContext truffleContext = this.context.getEnv().getContext();
                        Object p = truffleContext.enter();
                        try {
                            ((InteropLibrary)InteropLibrary.getFactory().getUncached()).execute((Object)this.handler, new Object[]{this.signal.getNumber()});
                        }
                        finally {
                            truffleContext.leave(p);
                        }
                    }
                    catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                        throw new AssertionError((Object)e);
                    }
                }
                finally {
                    this.lock.unlock();
                    globalSignalHandlerLock.unlock();
                }
            }
            if (!this.isRunning.get()) {
                this.unregisterFromContext();
            }
        }

        @CompilerDirectives.TruffleBoundary
        private void setStopped() {
            this.isRunning.set(false);
            this.tryUnregisterFromContext();
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void stop() {
            if (this.isRunning.getAndSet(false)) {
                Signal.handle(this.signal, SignalHandler.SIG_DFL);
            }
            this.tryUnregisterFromContext();
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void awaitFinish() {
            this.stop();
            this.lock.lock();
            this.lock.unlock();
            this.unregisterFromContext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private void unregisterFromContext() {
            assert (!this.isRunning.get());
            this.context.unregisterThread(this);
            int signalId = this.signal.getNumber();
            Map map = registeredSignals;
            synchronized (map) {
                if (registeredSignals.get(signalId) == this) {
                    registeredSignals.remove(signalId);
                }
            }
        }

        @CompilerDirectives.TruffleBoundary
        private boolean tryUnregisterFromContext() {
            assert (!this.isRunning.get());
            if (this.lock.tryLock()) {
                try {
                    this.unregisterFromContext();
                }
                finally {
                    this.lock.unlock();
                }
                return true;
            }
            return false;
        }

        @CompilerDirectives.TruffleBoundary
        public String toString() {
            return "LLVMSignalHandler [signal=" + this.signal + ", lock=" + this.lock + ", isRunning=" + this.isRunning + "]";
        }
    }
}

