/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.c;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.c.LLVMSyscall;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@GeneratedBy(value=LLVMSyscall.class)
public final class LLVMSyscallFactory {

    @GeneratedBy(value=LLVMSyscall.SyscallArgConverter.class)
    static final class SyscallArgConverterNodeGen
    extends LLVMSyscall.SyscallArgConverter {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode value_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private SyscallArgConverterNodeGen(LLVMExpressionNode value) {
            this.value_ = value;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0x3E) == 0 && state != 0) {
                return this.executeGeneric_long0(frameValue, state);
            }
            if ((state & 0x3D) == 0 && state != 0) {
                return this.executeGeneric_int1(frameValue, state);
            }
            if ((state & 0x3B) == 0 && state != 0) {
                return this.executeGeneric_short2(frameValue, state);
            }
            if ((state & 0x37) == 0 && state != 0) {
                return this.executeGeneric_byte3(frameValue, state);
            }
            return this.executeGeneric_generic4(frameValue, state);
        }

        private Object executeGeneric_long0(VirtualFrame frameValue, int state) {
            long valueValue_;
            try {
                valueValue_ = this.value_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
        }

        private Object executeGeneric_int1(VirtualFrame frameValue, int state) {
            int valueValue_;
            try {
                valueValue_ = this.value_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
        }

        private Object executeGeneric_short2(VirtualFrame frameValue, int state) {
            short valueValue_;
            try {
                valueValue_ = this.value_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 4) != 0);
            return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
        }

        private Object executeGeneric_byte3(VirtualFrame frameValue, int state) {
            byte valueValue_;
            try {
                valueValue_ = this.value_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 8) != 0);
            return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
        }

        private Object executeGeneric_generic4(VirtualFrame frameValue, int state) {
            Object valueValue_ = this.value_.executeGeneric(frameValue);
            if ((state & 1) != 0 && valueValue_ instanceof Long) {
                long valueValue__ = (Long)valueValue_;
                return LLVMSyscall.SyscallArgConverter.convert(valueValue__);
            }
            if ((state & 2) != 0 && valueValue_ instanceof Integer) {
                int valueValue__ = (Integer)valueValue_;
                return LLVMSyscall.SyscallArgConverter.convert(valueValue__);
            }
            if ((state & 4) != 0 && valueValue_ instanceof Short) {
                short valueValue__ = (Short)valueValue_;
                return LLVMSyscall.SyscallArgConverter.convert(valueValue__);
            }
            if ((state & 8) != 0 && valueValue_ instanceof Byte) {
                byte valueValue__ = (Byte)valueValue_;
                return LLVMSyscall.SyscallArgConverter.convert(valueValue__);
            }
            if ((state & 0x10) != 0 && LLVMTypes.isPointer(valueValue_)) {
                LLVMPointer valueValue__ = LLVMTypes.asPointer(valueValue_);
                return LLVMSyscall.SyscallArgConverter.convert(valueValue__);
            }
            if ((state & 0x20) != 0 && SyscallArgConverterNodeGen.fallbackGuard_(state, valueValue_)) {
                return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(valueValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            int state = this.state_;
            if ((state & 0x20) != 0) {
                return LLVMTypesGen.expectLong(this.executeGeneric(frameValue));
            }
            if ((state & 0xE) == 0 && (state & 0xF) != 0) {
                return this.executeI64_long5(frameValue, state);
            }
            if ((state & 0xD) == 0 && (state & 0xF) != 0) {
                return this.executeI64_int6(frameValue, state);
            }
            if ((state & 0xB) == 0 && (state & 0xF) != 0) {
                return this.executeI64_short7(frameValue, state);
            }
            if ((state & 7) == 0 && (state & 0xF) != 0) {
                return this.executeI64_byte8(frameValue, state);
            }
            return this.executeI64_generic9(frameValue, state);
        }

        private long executeI64_long5(VirtualFrame frameValue, int state) throws UnexpectedResultException {
            long valueValue_;
            try {
                valueValue_ = this.value_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            assert ((state & 1) != 0);
            return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
        }

        private long executeI64_int6(VirtualFrame frameValue, int state) throws UnexpectedResultException {
            int valueValue_;
            try {
                valueValue_ = this.value_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            assert ((state & 2) != 0);
            return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
        }

        private long executeI64_short7(VirtualFrame frameValue, int state) throws UnexpectedResultException {
            short valueValue_;
            try {
                valueValue_ = this.value_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            assert ((state & 4) != 0);
            return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
        }

        private long executeI64_byte8(VirtualFrame frameValue, int state) throws UnexpectedResultException {
            byte valueValue_;
            try {
                valueValue_ = this.value_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            assert ((state & 8) != 0);
            return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
        }

        private long executeI64_generic9(VirtualFrame frameValue, int state) throws UnexpectedResultException {
            Object valueValue_ = this.value_.executeGeneric(frameValue);
            if ((state & 1) != 0 && valueValue_ instanceof Long) {
                long valueValue__ = (Long)valueValue_;
                return LLVMSyscall.SyscallArgConverter.convert(valueValue__);
            }
            if ((state & 2) != 0 && valueValue_ instanceof Integer) {
                int valueValue__ = (Integer)valueValue_;
                return LLVMSyscall.SyscallArgConverter.convert(valueValue__);
            }
            if ((state & 4) != 0 && valueValue_ instanceof Short) {
                short valueValue__ = (Short)valueValue_;
                return LLVMSyscall.SyscallArgConverter.convert(valueValue__);
            }
            if ((state & 8) != 0 && valueValue_ instanceof Byte) {
                byte valueValue__ = (Byte)valueValue_;
                return LLVMSyscall.SyscallArgConverter.convert(valueValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(valueValue_));
        }

        private Object executeAndSpecialize(Object valueValue) {
            int state = this.state_;
            if (valueValue instanceof Long) {
                long valueValue_ = (Long)valueValue;
                this.state_ = state |= 1;
                return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
            }
            if (valueValue instanceof Integer) {
                int valueValue_ = (Integer)valueValue;
                this.state_ = state |= 2;
                return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
            }
            if (valueValue instanceof Short) {
                short valueValue_ = (Short)valueValue;
                this.state_ = state |= 4;
                return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
            }
            if (valueValue instanceof Byte) {
                byte valueValue_ = (Byte)valueValue;
                this.state_ = state |= 8;
                return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
            }
            if (LLVMTypes.isPointer(valueValue)) {
                LLVMPointer valueValue_ = LLVMTypes.asPointer(valueValue);
                this.state_ = state |= 0x10;
                return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
            }
            this.state_ = state |= 0x20;
            return LLVMSyscall.SyscallArgConverter.convert(valueValue);
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        private static boolean fallbackGuard_(int state, Object valueValue) {
            if ((state & 1) == 0 && valueValue instanceof Long) {
                return false;
            }
            if ((state & 2) == 0 && valueValue instanceof Integer) {
                return false;
            }
            if ((state & 4) == 0 && valueValue instanceof Short) {
                return false;
            }
            if ((state & 8) == 0 && valueValue instanceof Byte) {
                return false;
            }
            return (state & 0x10) != 0 || !LLVMTypes.isPointer(valueValue);
        }

        public static LLVMSyscall.SyscallArgConverter create(LLVMExpressionNode value) {
            return new SyscallArgConverterNodeGen(value);
        }
    }
}

