/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotFromStringNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadCharsetNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadCharsetNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI16LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI8LoadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@NodeChildren(value={@NodeChild(value="charset", type=LLVMReadCharsetNode.class), @NodeChild(value="rawString", type=ReadBytesNode.class, executeWith={"charset"})})
public abstract class LLVMPolyglotFromString
extends LLVMIntrinsic {
    public static LLVMPolyglotFromString create(LLVMExpressionNode string, LLVMExpressionNode charset) {
        LLVMReadCharsetNode charsetNode = LLVMReadCharsetNodeGen.create(charset);
        ReadZeroTerminatedBytesNode rawString = LLVMPolyglotFromStringNodeGen.ReadZeroTerminatedBytesNodeGen.create(null, string);
        return LLVMPolyglotFromStringNodeGen.create(charsetNode, rawString);
    }

    public static LLVMPolyglotFromString createN(LLVMExpressionNode string, LLVMExpressionNode n, LLVMExpressionNode charset) {
        LLVMReadCharsetNode charsetNode = LLVMReadCharsetNodeGen.create(charset);
        ReadBytesWithLengthNode rawString = LLVMPolyglotFromStringNodeGen.ReadBytesWithLengthNodeGen.create(null, string, n);
        return LLVMPolyglotFromStringNodeGen.create(charsetNode, rawString);
    }

    @Specialization
    LLVMManagedPointer doFromString(LLVMReadCharsetNode.LLVMCharset charset, ByteBuffer rawString) {
        return LLVMManagedPointer.create(charset.decode(rawString));
    }

    static abstract class PutCharNode
    extends LLVMNode {
        PutCharNode() {
        }

        protected abstract boolean execute(ByteBuffer var1, Object var2);

        @Specialization
        boolean doByte(ByteBuffer target, byte value) {
            if (value == 0) {
                return false;
            }
            target.put(value);
            return true;
        }

        @Specialization
        boolean doShort(ByteBuffer target, short value) {
            if (value == 0) {
                return false;
            }
            target.putShort(value);
            return true;
        }

        @Specialization
        boolean doInt(ByteBuffer target, int value) {
            if (value == 0) {
                return false;
            }
            target.putInt(value);
            return true;
        }

        @Specialization
        boolean doLong(ByteBuffer target, long value) {
            if (value == 0L) {
                return false;
            }
            target.putLong(value);
            return true;
        }

        public static PutCharNode create() {
            return LLVMPolyglotFromStringNodeGen.PutCharNodeGen.create();
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMReadCharsetNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    static abstract class ReadZeroTerminatedBytesNode
    extends ReadBytesNode {
        @CompilerDirectives.CompilationFinal
        int bufferSize = 8;

        ReadZeroTerminatedBytesNode() {
        }

        @Specialization(limit="4", guards={"charset.zeroTerminatorLen == increment"})
        ByteBuffer doRead(LLVMReadCharsetNode.LLVMCharset charset, LLVMPointer string, @Cached(value="charset.zeroTerminatorLen") int increment, @Cached(value="createLoad(increment)") LLVMLoadNode load, @Cached(value="create()") PutCharNode put) {
            Object value;
            int currentBufferSize = this.bufferSize;
            ByteBuffer result = ByteBuffer.allocate(currentBufferSize).order(ByteOrder.nativeOrder());
            LLVMPointer ptr = string;
            do {
                value = load.executeWithTarget(ptr);
                ptr = ptr.increment(increment);
                if (result.remaining() >= increment) continue;
                CompilerDirectives.transferToInterpreterAndInvalidate();
                ByteBuffer prev = result;
                result = ByteBuffer.allocate(currentBufferSize *= 2).order(ByteOrder.nativeOrder());
                prev.flip();
                result.put(prev);
            } while (put.execute(result, value));
            if (currentBufferSize > this.bufferSize) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.bufferSize = currentBufferSize;
            }
            result.flip();
            return result;
        }

        protected static LLVMLoadNode createLoad(int increment) {
            switch (increment) {
                case 1: {
                    return LLVMI8LoadNode.create();
                }
                case 2: {
                    return LLVMI16LoadNode.create();
                }
                case 4: {
                    return LLVMI32LoadNode.create();
                }
                case 8: {
                    return LLVMI64LoadNode.create();
                }
            }
            throw new AssertionError((Object)"should not reach here");
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMReadCharsetNode.class), @NodeChild(value="string", type=LLVMExpressionNode.class), @NodeChild(value="len", type=LLVMExpressionNode.class)})
    static abstract class ReadBytesWithLengthNode
    extends ReadBytesNode {
        @Node.Child
        private LLVMLoadNode load = LLVMI8LoadNode.create();

        ReadBytesWithLengthNode() {
        }

        @Specialization
        ByteBuffer doRead(LLVMReadCharsetNode.LLVMCharset charset, LLVMPointer string, long len) {
            ByteBuffer buffer = ByteBuffer.allocate((int)len);
            LLVMPointer ptr = string;
            int i = 0;
            while ((long)i < len) {
                byte value = (Byte)this.load.executeWithTarget(ptr);
                ptr = ptr.increment(1L);
                buffer.put(value);
                ++i;
            }
            buffer.flip();
            return buffer;
        }
    }

    static abstract class ReadBytesNode
    extends LLVMNode {
        ReadBytesNode() {
        }

        protected abstract ByteBuffer execute(VirtualFrame var1, LLVMReadCharsetNode.LLVMCharset var2);
    }
}

