/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotImport;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadStringNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadStringNodeGen;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMPolyglotImport.class)
public final class LLVMPolyglotImportNodeGen
extends LLVMPolyglotImport {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private LLVMSourceLocation sourceLocation;
    private boolean statement;
    @Node.Child
    private LLVMExpressionNode name_;
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_;
    @Node.Child
    private ImportData import_cache;

    private LLVMPolyglotImportNodeGen(LLVMExpressionNode name) {
        this.name_ = name;
    }

    @Override
    public LLVMSourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public void setSourceLocation(LLVMSourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    @Override
    protected boolean isStatement() {
        return this.statement;
    }

    @Override
    protected void setStatement(boolean statement) {
        this.statement = statement;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        ImportData s1_;
        int state = this.state_;
        Object nameValue_ = this.name_.executeGeneric(frameValue);
        if (state != 0 && (s1_ = this.import_cache) != null) {
            TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
            LLVMContext ctx__ = (LLVMContext)lLVMLanguageContextReference__.get();
            return this.doImport(nameValue_, s1_.readString_, s1_.interop_, s1_.toLLVM_, s1_.notFound_, ctx__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(nameValue_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object nameValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            LLVMContext ctx__ = null;
            ImportData s1_ = (ImportData)super.insert((Node)new ImportData());
            s1_.readString_ = s1_.insertAccessor(LLVMReadStringNodeGen.create());
            s1_.interop_ = s1_.insertAccessor((InteropLibrary)INTEROP_LIBRARY_.createDispatched(3));
            s1_.toLLVM_ = s1_.insertAccessor(this.createToLLVM());
            s1_.notFound_ = BranchProfile.create();
            TruffleLanguage.ContextReference lLVMLanguageContextReference__1 = this.lLVMLanguageContextReference_;
            if (lLVMLanguageContextReference__1 == null) {
                this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__1 = super.lookupContextReference(LLVMLanguage.class);
            }
            ctx__ = (LLVMContext)lLVMLanguageContextReference__1.get();
            this.import_cache = s1_;
            this.state_ = state |= 1;
            lock.unlock();
            hasLock = false;
            Object object = this.doImport(nameValue, s1_.readString_, s1_.interop_, s1_.toLLVM_, s1_.notFound_, ctx__);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        return NodeCost.MONOMORPHIC;
    }

    public static LLVMPolyglotImport create(LLVMExpressionNode name) {
        return new LLVMPolyglotImportNodeGen(name);
    }

    @GeneratedBy(value=LLVMPolyglotImport.class)
    private static final class ImportData
    extends Node {
        @Node.Child
        LLVMReadStringNode readString_;
        @Node.Child
        InteropLibrary interop_;
        @Node.Child
        ForeignToLLVM toLLVM_;
        @CompilerDirectives.CompilationFinal
        BranchProfile notFound_;

        ImportData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

