/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadCharsetNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMReadCharsetNode.class)
public final class LLVMReadCharsetNodeGen
extends LLVMReadCharsetNode {
    @Node.Child
    private LLVMExpressionNode child0_;
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @CompilerDirectives.CompilationFinal
    private CachedPointerData cachedPointer_cache;
    @CompilerDirectives.CompilationFinal
    private CachedOtherData cachedOther_cache;

    private LLVMReadCharsetNodeGen(LLVMExpressionNode child0) {
        this.child0_ = child0;
    }

    @Override
    @ExplodeLoop
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        Object child0Value_ = this.child0_.executeGeneric(frameValue);
        if ((state & 1) != 0 && LLVMTypes.isPointer(child0Value_)) {
            LLVMPointer child0Value__ = LLVMTypes.asPointer(child0Value_);
            CachedPointerData s1_ = this.cachedPointer_cache;
            while (s1_ != null) {
                if (s1_.cachedPointer_.isSame(child0Value__)) {
                    return this.doCachedPointer(child0Value__, s1_.cachedPointer_, s1_.cachedCharset_);
                }
                s1_ = s1_.next_;
            }
        }
        if ((state & 6) != 0) {
            if ((state & 2) != 0) {
                CachedOtherData s2_ = this.cachedOther_cache;
                while (s2_ != null) {
                    if (child0Value_ == s2_.cachedAddress_) {
                        return this.doCachedOther(child0Value_, s2_.cachedAddress_, s2_.cachedCharset_);
                    }
                    s2_ = s2_.next_;
                }
            }
            if ((state & 4) != 0) {
                return this.doGeneric(child0Value_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(child0Value_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LLVMReadCharsetNode.LLVMCharset executeAndSpecialize(Object child0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if ((exclude & 1) == 0 && LLVMTypes.isPointer(child0Value)) {
                LLVMPointer cachedPointer__;
                LLVMPointer child0Value_ = LLVMTypes.asPointer(child0Value);
                int count1_ = 0;
                CachedPointerData s1_ = this.cachedPointer_cache;
                if ((state & 1) != 0) {
                    while (s1_ != null && !s1_.cachedPointer_.isSame(child0Value_)) {
                        s1_ = s1_.next_;
                        ++count1_;
                    }
                }
                if (s1_ == null && (cachedPointer__ = child0Value_).isSame(child0Value_) && count1_ < 3) {
                    s1_ = new CachedPointerData(this.cachedPointer_cache);
                    s1_.cachedPointer_ = cachedPointer__;
                    s1_.cachedCharset_ = this.doGeneric(cachedPointer__);
                    this.cachedPointer_cache = s1_;
                    this.state_ = state |= 1;
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    LLVMReadCharsetNode.LLVMCharset lLVMCharset = this.doCachedPointer(child0Value_, s1_.cachedPointer_, s1_.cachedCharset_);
                    return lLVMCharset;
                }
            }
            if ((exclude & 2) == 0) {
                int count2_ = 0;
                CachedOtherData s2_ = this.cachedOther_cache;
                if ((state & 2) != 0) {
                    while (s2_ != null && child0Value != s2_.cachedAddress_) {
                        s2_ = s2_.next_;
                        ++count2_;
                    }
                }
                if (s2_ == null && count2_ < 3) {
                    s2_ = new CachedOtherData(this.cachedOther_cache);
                    s2_.cachedAddress_ = child0Value;
                    s2_.cachedCharset_ = this.doGeneric(s2_.cachedAddress_);
                    this.cachedOther_cache = s2_;
                    this.state_ = state |= 2;
                }
                if (s2_ != null) {
                    lock.unlock();
                    hasLock = false;
                    LLVMReadCharsetNode.LLVMCharset lLVMCharset = this.doCachedOther(child0Value, s2_.cachedAddress_, s2_.cachedCharset_);
                    return lLVMCharset;
                }
            }
            this.exclude_ = exclude |= 3;
            this.cachedPointer_cache = null;
            this.cachedOther_cache = null;
            state &= 0xFFFFFFFC;
            this.state_ = state |= 4;
            lock.unlock();
            hasLock = false;
            LLVMReadCharsetNode.LLVMCharset lLVMCharset = this.doGeneric(child0Value);
            return lLVMCharset;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            CachedPointerData s1_ = this.cachedPointer_cache;
            CachedOtherData s2_ = this.cachedOther_cache;
            if (!(s1_ != null && s1_.next_ != null || s2_ != null && s2_.next_ != null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMReadCharsetNode create(LLVMExpressionNode child0) {
        return new LLVMReadCharsetNodeGen(child0);
    }

    @GeneratedBy(value=LLVMReadCharsetNode.class)
    private static final class CachedOtherData {
        @CompilerDirectives.CompilationFinal
        CachedOtherData next_;
        @CompilerDirectives.CompilationFinal
        Object cachedAddress_;
        @CompilerDirectives.CompilationFinal
        LLVMReadCharsetNode.LLVMCharset cachedCharset_;

        CachedOtherData(CachedOtherData next_) {
            this.next_ = next_;
        }
    }

    @GeneratedBy(value=LLVMReadCharsetNode.class)
    private static final class CachedPointerData {
        @CompilerDirectives.CompilationFinal
        CachedPointerData next_;
        @CompilerDirectives.CompilationFinal
        LLVMPointer cachedPointer_;
        @CompilerDirectives.CompilationFinal
        LLVMReadCharsetNode.LLVMCharset cachedCharset_;

        CachedPointerData(CachedPointerData next_) {
            this.next_ = next_;
        }
    }
}

