/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.memory.LLVMNativeMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@NodeChild(type=LLVMExpressionNode.class)
public abstract class LLVMTruffleIsHandleToManaged
extends LLVMIntrinsic {
    @Specialization
    protected boolean doLongCase(long address, @CachedLanguage LLVMLanguage language, @CachedContext(value=LLVMLanguage.class) TruffleLanguage.ContextReference<LLVMContext> context) {
        if (!language.getNoDerefHandleAssumption().isValid() && LLVMNativeMemory.isDerefHandleMemory(address)) {
            return ((LLVMContext)context.get()).getDerefHandleContainer().isHandle(address);
        }
        if (!language.getNoCommonHandleAssumption().isValid() && LLVMNativeMemory.isCommonHandleMemory(address)) {
            return ((LLVMContext)context.get()).getHandleContainer().isHandle(address);
        }
        return false;
    }

    @Specialization
    protected boolean doPointerCase(LLVMNativePointer a, @CachedLanguage LLVMLanguage language, @CachedContext(value=LLVMLanguage.class) TruffleLanguage.ContextReference<LLVMContext> context) {
        return this.doLongCase(a.asNative(), language, context);
    }

    @Fallback
    protected boolean doGeneric(Object object) {
        return false;
    }
}

