/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMTruffleIsHandleToManaged;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMTruffleIsHandleToManaged.class)
public final class LLVMTruffleIsHandleToManagedNodeGen
extends LLVMTruffleIsHandleToManaged {
    private LLVMSourceLocation sourceLocation;
    private boolean statement;
    @Node.Child
    private LLVMExpressionNode child0_;
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_;

    private LLVMTruffleIsHandleToManagedNodeGen(LLVMExpressionNode child0) {
        this.child0_ = child0;
    }

    @Override
    public LLVMSourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public void setSourceLocation(LLVMSourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    @Override
    protected boolean isStatement() {
        return this.statement;
    }

    @Override
    protected void setStatement(boolean statement) {
        this.statement = statement;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 6) == 0 && state != 0) {
            return this.executeGeneric_long0(frameValue, state);
        }
        return this.executeGeneric_generic1(frameValue, state);
    }

    private Object executeGeneric_long0(VirtualFrame frameValue, int state) {
        TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__;
        long child0Value_;
        try {
            child0Value_ = this.child0_.executeI64(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 1) != 0);
        TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__ = this.lLVMLanguageReference_;
        LLVMLanguage longCase_language__ = (LLVMLanguage)lLVMLanguageReference__.get();
        TruffleLanguage.ContextReference<LLVMContext> longCase_context__ = lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
        return this.doLongCase(child0Value_, longCase_language__, longCase_context__);
    }

    private Object executeGeneric_generic1(VirtualFrame frameValue, int state) {
        Object child0Value_ = this.child0_.executeGeneric(frameValue);
        if ((state & 1) != 0 && child0Value_ instanceof Long) {
            TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__1;
            long child0Value__ = (Long)child0Value_;
            TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__1 = this.lLVMLanguageReference_;
            LLVMLanguage longCase_language__ = (LLVMLanguage)lLVMLanguageReference__1.get();
            TruffleLanguage.ContextReference<LLVMContext> longCase_context__ = lLVMLanguageContextReference__1 = this.lLVMLanguageContextReference_;
            return this.doLongCase(child0Value__, longCase_language__, longCase_context__);
        }
        if ((state & 2) != 0 && LLVMTypes.isNativePointer(child0Value_)) {
            TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__2;
            LLVMNativePointer child0Value__ = LLVMTypes.asNativePointer(child0Value_);
            TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__2 = this.lLVMLanguageReference_;
            LLVMLanguage pointerCase_language__ = (LLVMLanguage)lLVMLanguageReference__2.get();
            TruffleLanguage.ContextReference<LLVMContext> pointerCase_context__ = lLVMLanguageContextReference__2 = this.lLVMLanguageContextReference_;
            return this.doPointerCase(child0Value__, pointerCase_language__, pointerCase_context__);
        }
        if ((state & 4) != 0 && LLVMTruffleIsHandleToManagedNodeGen.fallbackGuard_(state, child0Value_)) {
            return this.doGeneric(child0Value_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(child0Value_);
    }

    @Override
    public boolean executeI1(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 6) == 0 && state != 0) {
            return this.executeI1_long2(frameValue, state);
        }
        return this.executeI1_generic3(frameValue, state);
    }

    private boolean executeI1_long2(VirtualFrame frameValue, int state) {
        TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__3;
        long child0Value_;
        try {
            child0Value_ = this.child0_.executeI64(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 1) != 0);
        TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__3 = this.lLVMLanguageReference_;
        LLVMLanguage longCase_language__ = (LLVMLanguage)lLVMLanguageReference__3.get();
        TruffleLanguage.ContextReference<LLVMContext> longCase_context__ = lLVMLanguageContextReference__3 = this.lLVMLanguageContextReference_;
        return this.doLongCase(child0Value_, longCase_language__, longCase_context__);
    }

    private boolean executeI1_generic3(VirtualFrame frameValue, int state) {
        Object child0Value_ = this.child0_.executeGeneric(frameValue);
        if ((state & 1) != 0 && child0Value_ instanceof Long) {
            TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__4;
            long child0Value__ = (Long)child0Value_;
            TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__4 = this.lLVMLanguageReference_;
            LLVMLanguage longCase_language__ = (LLVMLanguage)lLVMLanguageReference__4.get();
            TruffleLanguage.ContextReference<LLVMContext> longCase_context__ = lLVMLanguageContextReference__4 = this.lLVMLanguageContextReference_;
            return this.doLongCase(child0Value__, longCase_language__, longCase_context__);
        }
        if ((state & 2) != 0 && LLVMTypes.isNativePointer(child0Value_)) {
            TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__5;
            LLVMNativePointer child0Value__ = LLVMTypes.asNativePointer(child0Value_);
            TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__5 = this.lLVMLanguageReference_;
            LLVMLanguage pointerCase_language__ = (LLVMLanguage)lLVMLanguageReference__5.get();
            TruffleLanguage.ContextReference<LLVMContext> pointerCase_context__ = lLVMLanguageContextReference__5 = this.lLVMLanguageContextReference_;
            return this.doPointerCase(child0Value__, pointerCase_language__, pointerCase_context__);
        }
        if ((state & 4) != 0 && LLVMTruffleIsHandleToManagedNodeGen.fallbackGuard_(state, child0Value_)) {
            return this.doGeneric(child0Value_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(child0Value_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeAndSpecialize(Object child0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            TruffleLanguage.ContextReference longCase_context__ = null;
            LLVMLanguage longCase_language__ = null;
            if (child0Value instanceof Long) {
                long child0Value_ = (Long)child0Value;
                TruffleLanguage.LanguageReference lLVMLanguageReference__6 = this.lLVMLanguageReference_;
                if (lLVMLanguageReference__6 == null) {
                    this.lLVMLanguageReference_ = lLVMLanguageReference__6 = super.lookupLanguageReference(LLVMLanguage.class);
                }
                longCase_language__ = (LLVMLanguage)lLVMLanguageReference__6.get();
                TruffleLanguage.ContextReference lLVMLanguageContextReference__6 = this.lLVMLanguageContextReference_;
                if (lLVMLanguageContextReference__6 == null) {
                    this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__6 = super.lookupContextReference(LLVMLanguage.class);
                }
                longCase_context__ = lLVMLanguageContextReference__6;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                boolean bl = this.doLongCase(child0Value_, longCase_language__, (TruffleLanguage.ContextReference<LLVMContext>)longCase_context__);
                return bl;
            }
            TruffleLanguage.ContextReference pointerCase_context__ = null;
            LLVMLanguage pointerCase_language__ = null;
            if (LLVMTypes.isNativePointer(child0Value)) {
                LLVMNativePointer child0Value_ = LLVMTypes.asNativePointer(child0Value);
                TruffleLanguage.LanguageReference lLVMLanguageReference__7 = this.lLVMLanguageReference_;
                if (lLVMLanguageReference__7 == null) {
                    this.lLVMLanguageReference_ = lLVMLanguageReference__7 = super.lookupLanguageReference(LLVMLanguage.class);
                }
                pointerCase_language__ = (LLVMLanguage)lLVMLanguageReference__7.get();
                TruffleLanguage.ContextReference lLVMLanguageContextReference__7 = this.lLVMLanguageContextReference_;
                if (lLVMLanguageContextReference__7 == null) {
                    this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__7 = super.lookupContextReference(LLVMLanguage.class);
                }
                pointerCase_context__ = lLVMLanguageContextReference__7;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                boolean bl = this.doPointerCase(child0Value_, pointerCase_language__, (TruffleLanguage.ContextReference<LLVMContext>)pointerCase_context__);
                return bl;
            }
            this.state_ = state |= 4;
            lock.unlock();
            hasLock = false;
            boolean bl = this.doGeneric(child0Value);
            return bl;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    private static boolean fallbackGuard_(int state, Object child0Value) {
        if ((state & 1) == 0 && child0Value instanceof Long) {
            return false;
        }
        return (state & 2) != 0 || !LLVMTypes.isNativePointer(child0Value);
    }

    public static LLVMTruffleIsHandleToManaged create(LLVMExpressionNode child0) {
        return new LLVMTruffleIsHandleToManagedNodeGen(child0);
    }
}

