/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.typed;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.typed.LLVMTypeIDNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMTypeIDNode.class)
public final class LLVMTypeIDNodeGen
extends LLVMTypeIDNode {
    private LLVMSourceLocation sourceLocation;
    private boolean statement;
    @Node.Child
    private LLVMExpressionNode child0_;
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_;

    private LLVMTypeIDNodeGen(LLVMExpressionNode child0) {
        this.child0_ = child0;
    }

    @Override
    public LLVMSourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public void setSourceLocation(LLVMSourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    @Override
    protected boolean isStatement() {
        return this.statement;
    }

    @Override
    protected void setStatement(boolean statement) {
        this.statement = statement;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state = this.state_;
        Object child0Value_ = this.child0_.executeGeneric(frameValue);
        if ((state & 1) != 0 && LLVMTypes.isPointer(child0Value_)) {
            TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__;
            LLVMPointer child0Value__ = LLVMTypes.asPointer(child0Value_);
            TruffleLanguage.ContextReference<LLVMContext> global_ctxRef__ = lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
            return this.doGlobal(child0Value__, global_ctxRef__);
        }
        if ((state & 2) != 0 && LLVMTypeIDNodeGen.fallbackGuard_(state, child0Value_)) {
            return this.fallback(child0Value_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(child0Value_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LLVMInteropType executeAndSpecialize(Object child0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            TruffleLanguage.ContextReference global_ctxRef__ = null;
            if (LLVMTypes.isPointer(child0Value)) {
                LLVMPointer child0Value_ = LLVMTypes.asPointer(child0Value);
                TruffleLanguage.ContextReference lLVMLanguageContextReference__1 = this.lLVMLanguageContextReference_;
                if (lLVMLanguageContextReference__1 == null) {
                    this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__1 = super.lookupContextReference(LLVMLanguage.class);
                }
                global_ctxRef__ = lLVMLanguageContextReference__1;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                LLVMInteropType lLVMInteropType = this.doGlobal(child0Value_, (TruffleLanguage.ContextReference<LLVMContext>)global_ctxRef__);
                return lLVMInteropType;
            }
            this.state_ = state |= 2;
            lock.unlock();
            hasLock = false;
            LLVMInteropType.Structured structured = this.fallback(child0Value);
            return structured;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    private static boolean fallbackGuard_(int state, Object child0Value) {
        return (state & 1) != 0 || !LLVMTypes.isPointer(child0Value);
    }

    public static LLVMTypeIDNode create(LLVMExpressionNode child0) {
        return new LLVMTypeIDNodeGen(child0);
    }
}

