/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMFrameAddress;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMFrameAddress.class)
public final class LLVMFrameAddressNodeGen
extends LLVMFrameAddress {
    private LLVMSourceLocation sourceLocation;
    private boolean statement;
    @Node.Child
    private LLVMExpressionNode val_;
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_;

    private LLVMFrameAddressNodeGen(LLVMExpressionNode val) {
        this.val_ = val;
    }

    @Override
    public LLVMSourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public void setSourceLocation(LLVMSourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    @Override
    protected boolean isStatement() {
        return this.statement;
    }

    @Override
    protected void setStatement(boolean statement) {
        this.statement = statement;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int valValue_;
        int state = this.state_;
        try {
            valValue_ = this.val_.executeI32(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(frameValue, ex.getResult());
        }
        if (state != 0) {
            TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__ = this.lLVMLanguageReference_;
            LLVMLanguage language__ = (LLVMLanguage)lLVMLanguageReference__.get();
            return this.doPointee(frameValue, valValue_, language__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, valValue_);
    }

    private LLVMNativePointer executeAndSpecialize(VirtualFrame frameValue, Object valValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            LLVMLanguage language__ = null;
            if (valValue instanceof Integer) {
                int valValue_ = (Integer)valValue;
                TruffleLanguage.LanguageReference lLVMLanguageReference__1 = this.lLVMLanguageReference_;
                if (lLVMLanguageReference__1 == null) {
                    this.lLVMLanguageReference_ = lLVMLanguageReference__1 = super.lookupLanguageReference(LLVMLanguage.class);
                }
                language__ = (LLVMLanguage)lLVMLanguageReference__1.get();
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                LLVMNativePointer lLVMNativePointer = this.doPointee(frameValue, valValue_, language__);
                return lLVMNativePointer;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.val_}, new Object[]{valValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        return NodeCost.MONOMORPHIC;
    }

    public static LLVMFrameAddress create(LLVMExpressionNode val) {
        return new LLVMFrameAddressNodeGen(val);
    }
}

