/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemSetNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMMemSet;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@GeneratedBy(value=LLVMMemSet.class)
public final class LLVMMemSetNodeGen
extends LLVMMemSet {
    private LLVMSourceLocation sourceLocation;
    private boolean statement;
    @Node.Child
    private LLVMExpressionNode address_;
    @Node.Child
    private LLVMExpressionNode value_;
    @Node.Child
    private LLVMExpressionNode length_;
    @Node.Child
    private LLVMExpressionNode isVolatile_;
    @CompilerDirectives.CompilationFinal
    private int state_;

    private LLVMMemSetNodeGen(LLVMMemSetNode memSet, LLVMExpressionNode address, LLVMExpressionNode value, LLVMExpressionNode length, LLVMExpressionNode isVolatile) {
        super(memSet);
        this.address_ = address;
        this.value_ = value;
        this.length_ = length;
        this.isVolatile_ = isVolatile;
    }

    @Override
    public LLVMSourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public void setSourceLocation(LLVMSourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    @Override
    protected boolean isStatement() {
        return this.statement;
    }

    @Override
    protected void setStatement(boolean statement) {
        this.statement = statement;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        byte valueValue_;
        int state = this.state_;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        try {
            valueValue_ = this.value_.executeI8(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object lengthValue = this.length_.executeGeneric(frameValue);
            Object isVolatileValue = this.isVolatile_.executeGeneric(frameValue);
            return this.executeAndSpecialize(addressValue_, ex.getResult(), lengthValue, isVolatileValue);
        }
        if ((state & 2) == 0 && state != 0) {
            return this.executeGeneric_int_boolean0(frameValue, state, addressValue_, valueValue_);
        }
        if ((state & 1) == 0 && state != 0) {
            return this.executeGeneric_long_boolean1(frameValue, state, addressValue_, valueValue_);
        }
        return this.executeGeneric_generic2(frameValue, state, addressValue_, valueValue_);
    }

    private Object executeGeneric_int_boolean0(VirtualFrame frameValue, int state, Object addressValue_, byte valueValue_) {
        boolean isVolatileValue_;
        int lengthValue_;
        try {
            lengthValue_ = this.length_.executeI32(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object isVolatileValue = this.isVolatile_.executeGeneric(frameValue);
            return this.executeAndSpecialize(addressValue_, valueValue_, ex.getResult(), isVolatileValue);
        }
        try {
            isVolatileValue_ = this.isVolatile_.executeI1(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(addressValue_, valueValue_, lengthValue_, ex.getResult());
        }
        assert ((state & 1) != 0);
        if (LLVMTypes.isPointer(addressValue_)) {
            LLVMPointer addressValue__ = LLVMTypes.asPointer(addressValue_);
            return this.doOp(addressValue__, valueValue_, lengthValue_, isVolatileValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(addressValue_, valueValue_, lengthValue_, isVolatileValue_);
    }

    private Object executeGeneric_long_boolean1(VirtualFrame frameValue, int state, Object addressValue_, byte valueValue_) {
        boolean isVolatileValue_;
        long lengthValue_;
        try {
            lengthValue_ = this.length_.executeI64(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object isVolatileValue = this.isVolatile_.executeGeneric(frameValue);
            return this.executeAndSpecialize(addressValue_, valueValue_, ex.getResult(), isVolatileValue);
        }
        try {
            isVolatileValue_ = this.isVolatile_.executeI1(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(addressValue_, valueValue_, lengthValue_, ex.getResult());
        }
        assert ((state & 2) != 0);
        if (LLVMTypes.isPointer(addressValue_)) {
            LLVMPointer addressValue__ = LLVMTypes.asPointer(addressValue_);
            return this.doOp(addressValue__, valueValue_, lengthValue_, isVolatileValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(addressValue_, valueValue_, lengthValue_, isVolatileValue_);
    }

    private Object executeGeneric_generic2(VirtualFrame frameValue, int state, Object addressValue_, byte valueValue_) {
        boolean isVolatileValue_;
        Object lengthValue_ = this.length_.executeGeneric(frameValue);
        try {
            isVolatileValue_ = this.isVolatile_.executeI1(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(addressValue_, valueValue_, lengthValue_, ex.getResult());
        }
        if (state != 0 && LLVMTypes.isPointer(addressValue_)) {
            LLVMPointer addressValue__ = LLVMTypes.asPointer(addressValue_);
            if ((state & 1) != 0 && lengthValue_ instanceof Integer) {
                int lengthValue__ = (Integer)lengthValue_;
                return this.doOp(addressValue__, valueValue_, lengthValue__, isVolatileValue_);
            }
            if ((state & 2) != 0 && lengthValue_ instanceof Long) {
                long lengthValue__ = (Long)lengthValue_;
                return this.doOp(addressValue__, valueValue_, lengthValue__, isVolatileValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(addressValue_, valueValue_, lengthValue_, isVolatileValue_);
    }

    private Object executeAndSpecialize(Object addressValue, Object valueValue, Object lengthValue, Object isVolatileValue) {
        int state = this.state_;
        if (LLVMTypes.isPointer(addressValue)) {
            LLVMPointer addressValue_ = LLVMTypes.asPointer(addressValue);
            if (valueValue instanceof Byte) {
                byte valueValue_ = (Byte)valueValue;
                if (isVolatileValue instanceof Boolean) {
                    boolean isVolatileValue_ = (Boolean)isVolatileValue;
                    if (lengthValue instanceof Integer) {
                        int lengthValue_ = (Integer)lengthValue;
                        this.state_ = state |= 1;
                        return this.doOp(addressValue_, valueValue_, lengthValue_, isVolatileValue_);
                    }
                    if (lengthValue instanceof Long) {
                        long lengthValue_ = (Long)lengthValue;
                        this.state_ = state |= 2;
                        return this.doOp(addressValue_, valueValue_, lengthValue_, isVolatileValue_);
                    }
                }
            }
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_, this.value_, this.length_, this.isVolatile_}, new Object[]{addressValue, valueValue, lengthValue, isVolatileValue});
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMMemSet create(LLVMMemSetNode memSet, LLVMExpressionNode address, LLVMExpressionNode value, LLVMExpressionNode length, LLVMExpressionNode isVolatile) {
        return new LLVMMemSetNodeGen(memSet, address, value, length, isVolatile);
    }
}

