/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameUtil;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMBuiltin;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

public abstract class LLVMStackSave
extends LLVMBuiltin {
    @CompilerDirectives.CompilationFinal
    private FrameSlot stackPointer;

    private FrameSlot getStackPointerSlot() {
        if (this.stackPointer == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.stackPointer = this.getRootNode().getFrameDescriptor().findFrameSlot((Object)"<stackpointer>");
        }
        return this.stackPointer;
    }

    @Specialization
    protected LLVMNativePointer doPointee(VirtualFrame frame, @CachedLanguage LLVMLanguage language) {
        LLVMStack.StackPointer pointer = (LLVMStack.StackPointer)FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)this.getStackPointerSlot());
        return LLVMNativePointer.create(pointer.get(this, language.getLLVMMemory()));
    }
}

