/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.bit;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.bit.CountSetBitsNode;

@GeneratedBy(value=CountSetBitsNode.class)
public final class CountSetBitsNodeFactory {

    @GeneratedBy(value=CountSetBitsNode.CountSetBitsI64Node.class)
    public static final class CountSetBitsI64NodeGen
    extends CountSetBitsNode.CountSetBitsI64Node {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private CountSetBitsI64NodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            long child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doOp(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) {
            long child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doOp(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        private long executeAndSpecialize(Object child0Value) {
            int state = this.state_;
            if (child0Value instanceof Long) {
                long child0Value_ = (Long)child0Value;
                this.state_ = state |= 1;
                return this.doOp(child0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static CountSetBitsNode.CountSetBitsI64Node create(LLVMExpressionNode child0) {
            return new CountSetBitsI64NodeGen(child0);
        }
    }

    @GeneratedBy(value=CountSetBitsNode.CountSetBitsI32Node.class)
    public static final class CountSetBitsI32NodeGen
    extends CountSetBitsNode.CountSetBitsI32Node {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private CountSetBitsI32NodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doI32(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doI32(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        private int executeAndSpecialize(Object child0Value) {
            int state = this.state_;
            if (child0Value instanceof Integer) {
                int child0Value_ = (Integer)child0Value;
                this.state_ = state |= 1;
                return this.doI32(child0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static CountSetBitsNode.CountSetBitsI32Node create(LLVMExpressionNode child0) {
            return new CountSetBitsI32NodeGen(child0);
        }
    }
}

