/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.bit;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMBuiltin;

public abstract class CountTrailingZeroesNode {

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class CountTrailingZeroesI64Node
    extends LLVMBuiltin {
        @Specialization
        protected long doI64(long val, boolean isZeroUndefined) {
            return Long.numberOfTrailingZeros(val);
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class CountTrailingZeroesI32Node
    extends LLVMBuiltin {
        @Specialization
        protected int doI32(int val, boolean isZeroUndefined) {
            return Integer.numberOfTrailingZeros(val);
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class CountTrailingZeroesI16Node
    extends LLVMBuiltin {
        @Specialization
        protected short doI16(short val, boolean isZeroUndefined) {
            int trailingZeroes = Integer.numberOfTrailingZeros(val);
            return (short)(trailingZeroes > 16 ? 16 : trailingZeroes);
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class CountTrailingZeroesI8Node
    extends LLVMBuiltin {
        @Specialization
        protected byte doI8(byte val, boolean isZeroUndefined) {
            int trailingZeroes = Integer.numberOfTrailingZeros(val);
            return (byte)(trailingZeroes > 8 ? 8 : trailingZeroes);
        }
    }
}

