/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.utilities.AssumedValue;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.debug.LLDBSupport;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugTypeConstants;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugValue;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLDBMemoryValue;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.function.Function;

final class LLDBGlobalConstant
implements LLVMDebugValue {
    private final LLVMGlobal global;
    private final LLVMContext context;

    LLDBGlobalConstant(LLVMGlobal global, LLVMContext context) {
        this.global = global;
        this.context = context;
    }

    @Override
    public boolean canRead(long bitOffset, int bits) {
        return this.canRead(bitOffset, bits, this.getCurrentValue());
    }

    private boolean canRead(long bitOffset, int bits, LLVMDebugValue currentValue) {
        int index = this.global.getSymbolIndex(false);
        AssumedValue<LLVMPointer>[] globals = this.context.findSymbolTable(this.global.getBitcodeID(false));
        return globals[index].get() != null && currentValue != null && currentValue.canRead(bitOffset, bits);
    }

    private Object doRead(long offset, int size, String kind, Function<LLVMDebugValue, Object> readOperation) {
        LLVMDebugValue value = this.getCurrentValue();
        if (value == null) {
            return "<unavailable>";
        }
        if (!this.canRead(offset, size, value)) {
            return this.cannotInterpret(kind, offset, size);
        }
        return readOperation.apply(value);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String describeValue(long bitOffset, int bitSize) {
        return String.format("%s (%s at offset %s)", this.global.getSourceName(), LLDBSupport.toSizeString(bitSize), LLDBSupport.toSizeString(bitOffset));
    }

    @Override
    public Object readBoolean(long bitOffset) {
        return this.doRead(bitOffset, 1, "boolean", value -> value.readBoolean(bitOffset));
    }

    @Override
    public Object readFloat(long bitOffset) {
        return this.doRead(bitOffset, 32, "float", value -> value.readFloat(bitOffset));
    }

    @Override
    public Object readDouble(long bitOffset) {
        return this.doRead(bitOffset, 64, "double", value -> value.readDouble(bitOffset));
    }

    @Override
    public Object read80BitFloat(long bitOffset) {
        return this.doRead(bitOffset, 80, "80bit float", value -> value.read80BitFloat(bitOffset));
    }

    @Override
    public Object readAddress(long bitOffset) {
        return this.doRead(bitOffset, 64, "address", value -> value.readAddress(bitOffset));
    }

    @Override
    public Object readUnknown(long bitOffset, int bitSize) {
        LLVMDebugValue value = this.getCurrentValue();
        if (value != null) {
            return value.readUnknown(bitOffset, bitSize);
        }
        return "<unavailable>";
    }

    @Override
    public Object computeAddress(long bitOffset) {
        LLVMDebugValue value = this.getCurrentValue();
        if (value != null) {
            return value.computeAddress(bitOffset);
        }
        return this.describeValue(bitOffset, 0);
    }

    @Override
    public Object readBigInteger(long bitOffset, int bitSize, boolean signed) {
        String kind = LLVMDebugTypeConstants.getIntegerKind(bitSize, signed);
        return this.doRead(bitOffset, bitSize, kind, value -> value.readBigInteger(bitOffset, bitSize, signed));
    }

    @Override
    public boolean isAlwaysSafeToDereference(long bitOffset) {
        LLVMDebugValue value = this.getCurrentValue();
        return value != null && value.isAlwaysSafeToDereference(bitOffset);
    }

    @Override
    public LLVMDebugValue dereferencePointer(long bitOffset) {
        LLVMDebugValue value = this.getCurrentValue();
        if (value != null) {
            return value.dereferencePointer(bitOffset);
        }
        return null;
    }

    @Override
    public boolean isInteropValue() {
        return this.asInteropValue() != null;
    }

    @Override
    public Object asInteropValue() {
        if (this.isInNative()) {
            return null;
        }
        LLVMDebugValue value = this.getCurrentValue();
        if (value != null && value.isInteropValue()) {
            return value.asInteropValue();
        }
        return null;
    }

    private LLVMDebugValue getCurrentValue() {
        int index = this.global.getSymbolIndex(false);
        AssumedValue<LLVMPointer>[] globals = this.context.findSymbolTable(this.global.getBitcodeID(false));
        if (this.isInNative()) {
            return new LLDBMemoryValue(LLVMNativePointer.cast(globals[index].get()));
        }
        return CommonNodeFactory.createDebugValueBuilder().build(globals[index].get());
    }

    private boolean isInNative() {
        int index = this.global.getSymbolIndex(false);
        AssumedValue<LLVMPointer>[] globals = this.context.findSymbolTable(this.global.getBitcodeID(false));
        return LLVMNativePointer.isInstance(globals[index].get());
    }
}

