/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.x86;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMBuiltin;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDirectLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
@NodeField(type=int.class, name="numberExplicitArguments")
public abstract class LLVMX86_64BitVACopy
extends LLVMBuiltin {
    @Node.Child
    private LLVMStoreNode gpOffsetStore = LLVMI32StoreNodeGen.create(null, null);
    @Node.Child
    private LLVMStoreNode fpOffsetStore = LLVMI32StoreNodeGen.create(null, null);
    @Node.Child
    private LLVMStoreNode overflowArgAreaStore = LLVMPointerStoreNodeGen.create(null, null);
    @Node.Child
    private LLVMStoreNode regSaveAreaStore = LLVMPointerStoreNodeGen.create(null, null);
    @Node.Child
    private LLVMLoadNode gpOffsetLoad = LLVMI32LoadNode.create();
    @Node.Child
    private LLVMLoadNode fpOffsetLoad = LLVMI32LoadNode.create();
    @Node.Child
    private LLVMLoadNode overflowArgAreaLoad = LLVMDirectLoadNode.LLVMPointerDirectLoadNode.create();
    @Node.Child
    private LLVMLoadNode regSaveAreaLoad = LLVMDirectLoadNode.LLVMPointerDirectLoadNode.create();

    private void setGPOffset(LLVMPointer address, int value) {
        LLVMPointer p = address.increment(0L);
        this.gpOffsetStore.executeWithTarget(p, value);
    }

    private void setFPOffset(LLVMPointer address, int value) {
        LLVMPointer p = address.increment(4L);
        this.fpOffsetStore.executeWithTarget(p, value);
    }

    private void setOverflowArgArea(LLVMPointer address, Object value) {
        LLVMPointer p = address.increment(8L);
        this.overflowArgAreaStore.executeWithTarget(p, value);
    }

    private void setRegSaveArea(LLVMPointer address, Object value) {
        LLVMPointer p = address.increment(16L);
        this.regSaveAreaStore.executeWithTarget(p, value);
    }

    private int getGPOffset(LLVMPointer address) {
        LLVMPointer p = address.increment(0L);
        return (Integer)this.gpOffsetLoad.executeWithTarget(p);
    }

    private int getFPOffset(LLVMPointer address) {
        LLVMPointer p = address.increment(4L);
        return (Integer)this.fpOffsetLoad.executeWithTarget(p);
    }

    private Object getOverflowArgArea(LLVMPointer address) {
        LLVMPointer p = address.increment(8L);
        return this.overflowArgAreaLoad.executeWithTarget(p);
    }

    private Object getRegSaveArea(LLVMPointer address) {
        LLVMPointer p = address.increment(16L);
        return this.regSaveAreaLoad.executeWithTarget(p);
    }

    public abstract int getNumberExplicitArguments();

    @Specialization
    protected Object doVoid(LLVMPointer dest, LLVMPointer source) {
        this.setGPOffset(dest, this.getGPOffset(source));
        this.setFPOffset(dest, this.getFPOffset(source));
        this.setOverflowArgArea(dest, this.getOverflowArgArea(source));
        this.setRegSaveArea(dest, this.getRegSaveArea(source));
        return null;
    }
}

