/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading.LLVMPThreadKeyIntrinsics;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMPThreadKeyIntrinsics.class)
public final class LLVMPThreadKeyIntrinsicsFactory {

    @GeneratedBy(value=LLVMPThreadKeyIntrinsics.LLVMPThreadSetSpecific.class)
    public static final class LLVMPThreadSetSpecificNodeGen
    extends LLVMPThreadKeyIntrinsics.LLVMPThreadSetSpecific {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode key_;
        @Node.Child
        private LLVMExpressionNode value_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_;

        private LLVMPThreadSetSpecificNodeGen(LLVMExpressionNode key, LLVMExpressionNode value) {
            this.key_ = key;
            this.value_ = value;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int keyValue_;
            int state = this.state_;
            try {
                keyValue_ = this.key_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.value_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), valueValue);
            }
            Object valueValue_ = this.value_.executeGeneric(frameValue);
            if (state != 0 && LLVMTypes.isPointer(valueValue_)) {
                LLVMPointer valueValue__ = LLVMTypes.asPointer(valueValue_);
                TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
                LLVMContext context__ = (LLVMContext)lLVMLanguageContextReference__.get();
                return this.doIntrinsic(keyValue_, valueValue__, context__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(keyValue_, valueValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int keyValue_;
            int state = this.state_;
            try {
                keyValue_ = this.key_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.value_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), valueValue);
            }
            Object valueValue_ = this.value_.executeGeneric(frameValue);
            if (state != 0 && LLVMTypes.isPointer(valueValue_)) {
                LLVMPointer valueValue__ = LLVMTypes.asPointer(valueValue_);
                TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__1 = this.lLVMLanguageContextReference_;
                LLVMContext context__ = (LLVMContext)lLVMLanguageContextReference__1.get();
                return this.doIntrinsic(keyValue_, valueValue__, context__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(keyValue_, valueValue_);
        }

        private int executeAndSpecialize(Object keyValue, Object valueValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                LLVMContext context__ = null;
                if (keyValue instanceof Integer) {
                    int keyValue_ = (Integer)keyValue;
                    if (LLVMTypes.isPointer(valueValue)) {
                        LLVMPointer valueValue_ = LLVMTypes.asPointer(valueValue);
                        TruffleLanguage.ContextReference lLVMLanguageContextReference__2 = this.lLVMLanguageContextReference_;
                        if (lLVMLanguageContextReference__2 == null) {
                            this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__2 = super.lookupContextReference(LLVMLanguage.class);
                        }
                        context__ = (LLVMContext)lLVMLanguageContextReference__2.get();
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        int n = this.doIntrinsic(keyValue_, valueValue_, context__);
                        return n;
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.key_, this.value_}, new Object[]{keyValue, valueValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMPThreadKeyIntrinsics.LLVMPThreadSetSpecific create(LLVMExpressionNode key, LLVMExpressionNode value) {
            return new LLVMPThreadSetSpecificNodeGen(key, value);
        }
    }

    @GeneratedBy(value=LLVMPThreadKeyIntrinsics.LLVMPThreadGetSpecific.class)
    public static final class LLVMPThreadGetSpecificNodeGen
    extends LLVMPThreadKeyIntrinsics.LLVMPThreadGetSpecific {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode key_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_;

        private LLVMPThreadGetSpecificNodeGen(LLVMExpressionNode key) {
            this.key_ = key;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int keyValue_;
            int state = this.state_;
            try {
                keyValue_ = this.key_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
                LLVMContext context__ = (LLVMContext)lLVMLanguageContextReference__.get();
                return this.doIntrinsic(keyValue_, context__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(keyValue_);
        }

        private LLVMPointer executeAndSpecialize(Object keyValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                LLVMContext context__ = null;
                if (keyValue instanceof Integer) {
                    int keyValue_ = (Integer)keyValue;
                    TruffleLanguage.ContextReference lLVMLanguageContextReference__1 = this.lLVMLanguageContextReference_;
                    if (lLVMLanguageContextReference__1 == null) {
                        this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__1 = super.lookupContextReference(LLVMLanguage.class);
                    }
                    context__ = (LLVMContext)lLVMLanguageContextReference__1.get();
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    LLVMPointer lLVMPointer = this.doIntrinsic(keyValue_, context__);
                    return lLVMPointer;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.key_}, new Object[]{keyValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMPThreadKeyIntrinsics.LLVMPThreadGetSpecific create(LLVMExpressionNode key) {
            return new LLVMPThreadGetSpecificNodeGen(key);
        }
    }

    @GeneratedBy(value=LLVMPThreadKeyIntrinsics.LLVMPThreadKeyDelete.class)
    public static final class LLVMPThreadKeyDeleteNodeGen
    extends LLVMPThreadKeyIntrinsics.LLVMPThreadKeyDelete {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode key_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_;

        private LLVMPThreadKeyDeleteNodeGen(LLVMExpressionNode key) {
            this.key_ = key;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int keyValue_;
            int state = this.state_;
            try {
                keyValue_ = this.key_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
                LLVMContext context__ = (LLVMContext)lLVMLanguageContextReference__.get();
                return this.doIntrinsic(keyValue_, context__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(keyValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int keyValue_;
            int state = this.state_;
            try {
                keyValue_ = this.key_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__1 = this.lLVMLanguageContextReference_;
                LLVMContext context__ = (LLVMContext)lLVMLanguageContextReference__1.get();
                return this.doIntrinsic(keyValue_, context__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(keyValue_);
        }

        private int executeAndSpecialize(Object keyValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                LLVMContext context__ = null;
                if (keyValue instanceof Integer) {
                    int keyValue_ = (Integer)keyValue;
                    TruffleLanguage.ContextReference lLVMLanguageContextReference__2 = this.lLVMLanguageContextReference_;
                    if (lLVMLanguageContextReference__2 == null) {
                        this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__2 = super.lookupContextReference(LLVMLanguage.class);
                    }
                    context__ = (LLVMContext)lLVMLanguageContextReference__2.get();
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    int n = this.doIntrinsic(keyValue_, context__);
                    return n;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.key_}, new Object[]{keyValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMPThreadKeyIntrinsics.LLVMPThreadKeyDelete create(LLVMExpressionNode key) {
            return new LLVMPThreadKeyDeleteNodeGen(key);
        }
    }

    @GeneratedBy(value=LLVMPThreadKeyIntrinsics.LLVMPThreadKeyCreate.class)
    public static final class LLVMPThreadKeyCreateNodeGen
    extends LLVMPThreadKeyIntrinsics.LLVMPThreadKeyCreate {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode destructor_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_;

        private LLVMPThreadKeyCreateNodeGen(LLVMExpressionNode destructor) {
            this.destructor_ = destructor;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object destructorValue_ = this.destructor_.executeGeneric(frameValue);
            if (state != 0 && LLVMTypes.isPointer(destructorValue_)) {
                LLVMPointer destructorValue__ = LLVMTypes.asPointer(destructorValue_);
                TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
                LLVMContext context__ = (LLVMContext)lLVMLanguageContextReference__.get();
                return this.doIntrinsic(destructorValue__, context__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(destructorValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int state = this.state_;
            Object destructorValue_ = this.destructor_.executeGeneric(frameValue);
            if (state != 0 && LLVMTypes.isPointer(destructorValue_)) {
                LLVMPointer destructorValue__ = LLVMTypes.asPointer(destructorValue_);
                TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__1 = this.lLVMLanguageContextReference_;
                LLVMContext context__ = (LLVMContext)lLVMLanguageContextReference__1.get();
                return this.doIntrinsic(destructorValue__, context__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(destructorValue_);
        }

        private int executeAndSpecialize(Object destructorValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                LLVMContext context__ = null;
                if (LLVMTypes.isPointer(destructorValue)) {
                    LLVMPointer destructorValue_ = LLVMTypes.asPointer(destructorValue);
                    TruffleLanguage.ContextReference lLVMLanguageContextReference__2 = this.lLVMLanguageContextReference_;
                    if (lLVMLanguageContextReference__2 == null) {
                        this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__2 = super.lookupContextReference(LLVMLanguage.class);
                    }
                    context__ = (LLVMContext)lLVMLanguageContextReference__2.get();
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    int n = this.doIntrinsic(destructorValue_, context__);
                    return n;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.destructor_}, new Object[]{destructorValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMPThreadKeyIntrinsics.LLVMPThreadKeyCreate create(LLVMExpressionNode destructor) {
            return new LLVMPThreadKeyCreateNodeGen(destructor);
        }
    }
}

