/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.sulong;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.api.Toolchain;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadStringNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.util.List;
import java.util.Objects;

public abstract class LLVMToolchainNode
extends LLVMIntrinsic {

    public static abstract class LLVMToolchainIdentifierNode
    extends LLVMToolchainNode {
        @Specialization
        protected Object doOp(@CachedContext(value=LLVMLanguage.class) LLVMContext ctx) {
            return LLVMManagedPointer.create(ctx.getToolchain().getIdentifier());
        }
    }

    @NodeChild(value="path", type=LLVMExpressionNode.class)
    public static abstract class LLVMToolchainPathNode
    extends LLVMToolchainNode {
        @Specialization
        protected Object doOp(Object path, @CachedContext(value=LLVMLanguage.class) LLVMContext ctx, @Cached LLVMReadStringNode readString) {
            List<TruffleFile> paths = LLVMToolchainPathNode.getPaths(ctx.getToolchain(), readString.executeWithTarget(path));
            if (paths == null) {
                return LLVMNativePointer.createNull();
            }
            return LLVMContext.toTruffleObjects(LLVMToolchainPathNode.toArray(paths));
        }

        @CompilerDirectives.TruffleBoundary
        private static String[] toArray(List<TruffleFile> paths) {
            return (String[])paths.stream().map(Objects::toString).toArray(String[]::new);
        }

        @CompilerDirectives.TruffleBoundary
        private static List<TruffleFile> getPaths(Toolchain toolchain, String pathName) {
            return toolchain.getPaths(pathName);
        }
    }

    @NodeChild(value="name", type=LLVMExpressionNode.class)
    public static abstract class LLVMToolchainToolNode
    extends LLVMToolchainNode {
        @Specialization
        protected Object doOp(Object name, @CachedContext(value=LLVMLanguage.class) LLVMContext ctx, @Cached LLVMReadStringNode readString) {
            TruffleFile path = LLVMToolchainToolNode.getToolPath(ctx.getToolchain(), readString.executeWithTarget(name));
            if (path == null) {
                return LLVMNativePointer.createNull();
            }
            return LLVMManagedPointer.create(path.toString());
        }

        @CompilerDirectives.TruffleBoundary
        private static TruffleFile getToolPath(Toolchain toolchain, String tool) {
            return toolchain.getToolPath(tool);
        }
    }
}

