/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.except.LLVMAllocationFailureException;
import com.oracle.truffle.llvm.runtime.except.LLVMStackOverflowError;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMCompareExchangeNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI16LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI8LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI16StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI16StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI8StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI8StoreNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.AggregateType;
import com.oracle.truffle.llvm.runtime.types.Type;

@NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class, value="address"), @NodeChild(type=LLVMExpressionNode.class, value="comparisonValue"), @NodeChild(type=LLVMExpressionNode.class, value="newValue")})
public abstract class LLVMCompareExchangeNode
extends LLVMExpressionNode {
    @Node.Child
    private LLVMCMPXCHInternalNode cmpxch;

    public static LLVMCompareExchangeNode create(AggregateType returnType, DataLayout dataLayout, LLVMExpressionNode address, LLVMExpressionNode comparisonValue, LLVMExpressionNode newValue) throws Type.TypeOverflowException {
        long resultSize = returnType.getSize(dataLayout);
        long secondValueOffset = returnType.getOffsetOf(1L, dataLayout);
        return LLVMCompareExchangeNodeGen.create(resultSize, secondValueOffset, address, comparisonValue, newValue);
    }

    public LLVMCompareExchangeNode(long resultSize, long secondValueOffset) {
        this.cmpxch = LLVMCompareExchangeNodeGen.LLVMCMPXCHInternalNodeGen.create(resultSize, secondValueOffset);
    }

    @Specialization
    protected Object doOp(VirtualFrame frame, LLVMPointer address, Object comparisonValue, Object newValue) {
        return this.cmpxch.executeWithTarget(frame, address, comparisonValue, newValue);
    }

    static abstract class LLVMCMPXCHInternalNode
    extends LLVMNode {
        private final long resultSize;
        private final long secondValueOffset;
        @CompilerDirectives.CompilationFinal
        private FrameSlot stackPointerSlot;

        LLVMCMPXCHInternalNode(long resultSize, long secondValueOffset) {
            this.resultSize = resultSize;
            this.secondValueOffset = secondValueOffset;
        }

        private FrameSlot getStackPointerSlot() {
            if (this.stackPointerSlot == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.stackPointerSlot = this.getRootNode().getFrameDescriptor().findFrameSlot((Object)"<stackpointer>");
            }
            return this.stackPointerSlot;
        }

        public abstract Object executeWithTarget(VirtualFrame var1, Object var2, Object var3, Object var4);

        @Specialization
        protected Object doOp(VirtualFrame frame, LLVMNativePointer address, byte comparisonValue, byte newValue, @CachedLanguage LLVMLanguage language) {
            LLVMMemory memory = language.getLLVMMemory();
            LLVMMemory.CMPXCHGI8 compareAndSwapI8 = memory.compareAndSwapI8(this, address, comparisonValue, newValue);
            LLVMNativePointer allocation = this.allocateResult(frame, memory);
            memory.putI8((Node)this, allocation, compareAndSwapI8.getValue());
            memory.putI1((Node)this, allocation.increment(this.secondValueOffset), compareAndSwapI8.isSwap());
            return allocation;
        }

        @Specialization
        protected Object doOp(VirtualFrame frame, LLVMNativePointer address, short comparisonValue, short newValue, @CachedLanguage LLVMLanguage language) {
            LLVMMemory memory = language.getLLVMMemory();
            LLVMMemory.CMPXCHGI16 compareAndSwapI16 = memory.compareAndSwapI16(this, address, comparisonValue, newValue);
            LLVMNativePointer allocation = this.allocateResult(frame, memory);
            memory.putI16((Node)this, allocation, compareAndSwapI16.getValue());
            memory.putI1((Node)this, allocation.increment(this.secondValueOffset), compareAndSwapI16.isSwap());
            return allocation;
        }

        @Specialization
        protected Object doOp(VirtualFrame frame, LLVMNativePointer address, int comparisonValue, int newValue, @CachedLanguage LLVMLanguage language) {
            LLVMMemory memory = language.getLLVMMemory();
            LLVMMemory.CMPXCHGI32 compareAndSwapI32 = memory.compareAndSwapI32(this, address, comparisonValue, newValue);
            LLVMNativePointer allocation = this.allocateResult(frame, memory);
            memory.putI32((Node)this, allocation, compareAndSwapI32.getValue());
            memory.putI1((Node)this, allocation.increment(this.secondValueOffset), compareAndSwapI32.isSwap());
            return allocation;
        }

        @Specialization
        protected Object doOp(VirtualFrame frame, LLVMNativePointer address, long comparisonValue, long newValue, @CachedLanguage LLVMLanguage language) {
            LLVMMemory memory = language.getLLVMMemory();
            LLVMMemory.CMPXCHGI64 compareAndSwapI64 = memory.compareAndSwapI64(this, address, comparisonValue, newValue);
            LLVMNativePointer allocation = this.allocateResult(frame, memory);
            memory.putI64((Node)this, allocation, compareAndSwapI64.getValue());
            memory.putI1((Node)this, allocation.increment(this.secondValueOffset), compareAndSwapI64.isSwap());
            return allocation;
        }

        @Specialization
        protected Object doOp(VirtualFrame frame, LLVMNativePointer address, LLVMNativePointer comparisonValue, LLVMNativePointer newValue, @CachedLanguage LLVMLanguage language) {
            return this.doOp(frame, address, comparisonValue.asNative(), newValue.asNative(), language);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected Object doOp(VirtualFrame frame, LLVMManagedPointer address, byte comparisonValue, byte newValue, @Cached(value="createI8Read()") LLVMI8LoadNode read, @Cached(value="createI8Write()") LLVMI8StoreNode write, @CachedLanguage LLVMLanguage language) {
            LLVMMemory memory = language.getLLVMMemory();
            Object object = address.getObject();
            synchronized (object) {
                boolean success;
                LLVMNativePointer allocation = this.allocateResult(frame, memory);
                byte currentValue = (Byte)read.executeWithTarget(address);
                boolean bl = success = currentValue == comparisonValue;
                if (success) {
                    write.executeWithTarget(address, newValue);
                }
                memory.putI8((Node)this, allocation, currentValue);
                memory.putI1((Node)this, allocation.increment(this.secondValueOffset), success);
                return allocation;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected Object doOp(VirtualFrame frame, LLVMManagedPointer address, short comparisonValue, short newValue, @Cached(value="createI16Read()") LLVMI16LoadNode read, @Cached(value="createI16Write()") LLVMI16StoreNode write, @CachedLanguage LLVMLanguage language) {
            LLVMMemory memory = language.getLLVMMemory();
            Object object = address.getObject();
            synchronized (object) {
                boolean success;
                LLVMNativePointer allocation = this.allocateResult(frame, memory);
                short currentValue = (Short)read.executeWithTarget(address);
                boolean bl = success = currentValue == comparisonValue;
                if (success) {
                    write.executeWithTarget(address, newValue);
                }
                memory.putI16((Node)this, allocation, currentValue);
                memory.putI1((Node)this, allocation.increment(this.secondValueOffset), success);
                return allocation;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected Object doOp(VirtualFrame frame, LLVMManagedPointer address, int comparisonValue, int newValue, @Cached(value="createI32Read()") LLVMI32LoadNode read, @Cached(value="createI32Write()") LLVMI32StoreNode write, @CachedLanguage LLVMLanguage language) {
            LLVMMemory memory = language.getLLVMMemory();
            Object object = address.getObject();
            synchronized (object) {
                boolean success;
                LLVMNativePointer allocation = this.allocateResult(frame, memory);
                int currentValue = (Integer)read.executeWithTarget(address);
                boolean bl = success = currentValue == comparisonValue;
                if (success) {
                    write.executeWithTarget(address, newValue);
                }
                memory.putI32((Node)this, allocation, currentValue);
                memory.putI1((Node)this, allocation.increment(this.secondValueOffset), success);
                return allocation;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected Object doOp(VirtualFrame frame, LLVMManagedPointer address, long comparisonValue, long newValue, @Cached(value="createI64Read()") LLVMI64LoadNode read, @Cached(value="createI64Write()") LLVMI64StoreNode write, @CachedLanguage LLVMLanguage language) {
            LLVMMemory memory = language.getLLVMMemory();
            Object object = address.getObject();
            synchronized (object) {
                boolean success;
                LLVMNativePointer allocation = this.allocateResult(frame, memory);
                long currentValue = (Long)read.executeWithTarget(address);
                boolean bl = success = currentValue == comparisonValue;
                if (success) {
                    write.executeWithTarget(address, newValue);
                }
                memory.putI64((Node)this, allocation, currentValue);
                memory.putI1((Node)this, allocation.increment(this.secondValueOffset), success);
                return allocation;
            }
        }

        @Specialization
        protected Object doOp(VirtualFrame frame, LLVMManagedPointer address, LLVMNativePointer comparisonValue, LLVMNativePointer newValue, @Cached(value="createI64Read()") LLVMI64LoadNode read, @Cached(value="createI64Write()") LLVMI64StoreNode write, @CachedLanguage LLVMLanguage language) {
            return this.doOp(frame, address, comparisonValue.asNative(), newValue.asNative(), read, write, language);
        }

        private LLVMNativePointer allocateResult(VirtualFrame frame, LLVMMemory memory) {
            try {
                return LLVMNativePointer.create(LLVMStack.allocateStackMemory(this, frame, memory, this.getStackPointerSlot(), this.resultSize, 8));
            }
            catch (LLVMStackOverflowError soe) {
                CompilerDirectives.transferToInterpreter();
                throw new LLVMAllocationFailureException((Node)this, soe);
            }
        }

        protected static LLVMI8LoadNode createI8Read() {
            return LLVMI8LoadNode.create();
        }

        protected static LLVMI8StoreNode createI8Write() {
            return LLVMI8StoreNodeGen.create(null, null);
        }

        protected static LLVMI16LoadNode createI16Read() {
            return LLVMI16LoadNode.create();
        }

        protected static LLVMI16StoreNode createI16Write() {
            return LLVMI16StoreNodeGen.create(null, null);
        }

        protected static LLVMI32LoadNode createI32Read() {
            return LLVMI32LoadNode.create();
        }

        protected static LLVMI32StoreNode createI32Write() {
            return LLVMI32StoreNodeGen.create(null, null);
        }

        protected static LLVMI64LoadNode createI64Read() {
            return LLVMI64LoadNode.create();
        }

        protected static LLVMI64StoreNode createI64Write() {
            return LLVMI64StoreNodeGen.create(null, null);
        }
    }
}

