/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMFence;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMFence.class)
public final class LLVMFenceNodeGen
extends LLVMFence {
    private LLVMSourceLocation sourceLocation;
    private boolean statement;
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_;

    private LLVMFenceNodeGen() {
    }

    @Override
    public LLVMSourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public void setSourceLocation(LLVMSourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    @Override
    protected boolean isStatement() {
        return this.statement;
    }

    @Override
    protected void setStatement(boolean statement) {
        this.statement = statement;
    }

    @Override
    public void execute(VirtualFrame frameValue) {
        int state = this.state_;
        if (state != 0) {
            TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__ = this.lLVMLanguageReference_;
            LLVMLanguage language__ = (LLVMLanguage)lLVMLanguageReference__.get();
            this.doOp(language__);
            return;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAndSpecialize() {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            LLVMLanguage language__ = null;
            TruffleLanguage.LanguageReference lLVMLanguageReference__1 = this.lLVMLanguageReference_;
            if (lLVMLanguageReference__1 == null) {
                this.lLVMLanguageReference_ = lLVMLanguageReference__1 = super.lookupLanguageReference(LLVMLanguage.class);
            }
            language__ = (LLVMLanguage)lLVMLanguageReference__1.get();
            this.state_ = state |= 1;
            lock.unlock();
            hasLock = false;
            this.doOp(language__);
            return;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        return NodeCost.MONOMORPHIC;
    }

    public static LLVMFence create() {
        return new LLVMFenceNodeGen();
    }
}

