/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMGetStackSpaceInstruction;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMGetStackSpaceInstruction.class)
public final class LLVMGetStackSpaceInstructionFactory {

    @GeneratedBy(value=LLVMGetStackSpaceInstruction.LLVMAllocaInstruction.class)
    public static final class LLVMAllocaInstructionNodeGen
    extends LLVMGetStackSpaceInstruction.LLVMAllocaInstruction {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_;

        private LLVMAllocaInstructionNodeGen(long size, int alignment, Type symbolType, LLVMExpressionNode child0) {
            super(size, alignment, symbolType);
            this.child0_ = child0;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 2) == 0 && state != 0) {
                return this.executeGeneric_int0(frameValue, state);
            }
            if ((state & 1) == 0 && state != 0) {
                return this.executeGeneric_long1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_int0(VirtualFrame frameValue, int state) {
            int child0Value_;
            try {
                child0Value_ = this.child0_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(frameValue, ex.getResult());
            }
            assert ((state & 1) != 0);
            TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__ = this.lLVMLanguageReference_;
            LLVMLanguage op0_language__ = (LLVMLanguage)lLVMLanguageReference__.get();
            return this.doOp(frameValue, child0Value_, op0_language__);
        }

        private Object executeGeneric_long1(VirtualFrame frameValue, int state) {
            long child0Value_;
            try {
                child0Value_ = this.child0_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(frameValue, ex.getResult());
            }
            assert ((state & 2) != 0);
            TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__1 = this.lLVMLanguageReference_;
            LLVMLanguage op1_language__ = (LLVMLanguage)lLVMLanguageReference__1.get();
            return this.doOp(frameValue, child0Value_, op1_language__);
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state & 1) != 0 && child0Value_ instanceof Integer) {
                int child0Value__ = (Integer)child0Value_;
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__2 = this.lLVMLanguageReference_;
                LLVMLanguage op0_language__ = (LLVMLanguage)lLVMLanguageReference__2.get();
                return this.doOp(frameValue, child0Value__, op0_language__);
            }
            if ((state & 2) != 0 && child0Value_ instanceof Long) {
                long child0Value__ = (Long)child0Value_;
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__3 = this.lLVMLanguageReference_;
                LLVMLanguage op1_language__ = (LLVMLanguage)lLVMLanguageReference__3.get();
                return this.doOp(frameValue, child0Value__, op1_language__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, child0Value_);
        }

        private LLVMNativePointer executeAndSpecialize(VirtualFrame frameValue, Object child0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                LLVMLanguage op0_language__ = null;
                if (child0Value instanceof Integer) {
                    int child0Value_ = (Integer)child0Value;
                    TruffleLanguage.LanguageReference lLVMLanguageReference__4 = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__4 == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__4 = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    op0_language__ = (LLVMLanguage)lLVMLanguageReference__4.get();
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    LLVMNativePointer lLVMNativePointer = this.doOp(frameValue, child0Value_, op0_language__);
                    return lLVMNativePointer;
                }
                LLVMLanguage op1_language__ = null;
                if (child0Value instanceof Long) {
                    long child0Value_ = (Long)child0Value;
                    TruffleLanguage.LanguageReference lLVMLanguageReference__5 = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__5 == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__5 = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    op1_language__ = (LLVMLanguage)lLVMLanguageReference__5.get();
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    LLVMNativePointer lLVMNativePointer = this.doOp(frameValue, child0Value_, op1_language__);
                    return lLVMNativePointer;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMGetStackSpaceInstruction.LLVMAllocaInstruction create(long size, int alignment, Type symbolType, LLVMExpressionNode child0) {
            return new LLVMAllocaInstructionNodeGen(size, alignment, symbolType, child0);
        }
    }

    @GeneratedBy(value=LLVMGetStackSpaceInstruction.LLVMGetUniqueStackSpaceInstruction.class)
    public static final class LLVMGetUniqueStackSpaceInstructionNodeGen
    extends LLVMGetStackSpaceInstruction.LLVMGetUniqueStackSpaceInstruction {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;

        private LLVMGetUniqueStackSpaceInstructionNodeGen(long size, int alignment, Type symbolType, LLVMStack.UniquesRegion.UniqueSlot uniqueSlot) {
            super(size, alignment, symbolType, uniqueSlot);
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            return this.doOp(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMGetStackSpaceInstruction.LLVMGetUniqueStackSpaceInstruction create(long size, int alignment, Type symbolType, LLVMStack.UniquesRegion.UniqueSlot uniqueSlot) {
            return new LLVMGetUniqueStackSpaceInstructionNodeGen(size, alignment, symbolType, uniqueSlot);
        }
    }

    @GeneratedBy(value=LLVMGetStackSpaceInstruction.LLVMAllocaConstInstruction.class)
    public static final class LLVMAllocaConstInstructionNodeGen
    extends LLVMGetStackSpaceInstruction.LLVMAllocaConstInstruction {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_;

        private LLVMAllocaConstInstructionNodeGen(long size, int alignment, Type symbolType) {
            super(size, alignment, symbolType);
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if (state != 0) {
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__ = this.lLVMLanguageReference_;
                LLVMLanguage language__ = (LLVMLanguage)lLVMLanguageReference__.get();
                return this.doOp(frameValue, language__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LLVMNativePointer executeAndSpecialize(VirtualFrame frameValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                LLVMLanguage language__ = null;
                TruffleLanguage.LanguageReference lLVMLanguageReference__1 = this.lLVMLanguageReference_;
                if (lLVMLanguageReference__1 == null) {
                    this.lLVMLanguageReference_ = lLVMLanguageReference__1 = super.lookupLanguageReference(LLVMLanguage.class);
                }
                language__ = (LLVMLanguage)lLVMLanguageReference__1.get();
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                LLVMNativePointer lLVMNativePointer = this.doOp(frameValue, language__);
                return lLVMNativePointer;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMGetStackSpaceInstruction.LLVMAllocaConstInstruction create(long size, int alignment, Type symbolType) {
            return new LLVMAllocaConstInstructionNodeGen(size, alignment, symbolType);
        }
    }
}

