/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.NFIContextExtension;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemoryOpNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public final class ProtectReadOnlyGlobalsBlockNode
extends LLVMNode
implements LLVMMemoryOpNode {
    @Node.Child
    InteropLibrary interop;
    private final TruffleObject protectReadonlyGlobalsBlock;

    public ProtectReadOnlyGlobalsBlockNode(LLVMContext context) {
        NFIContextExtension nfiContextExtension = context.getContextExtensionOrNull(NFIContextExtension.class);
        this.protectReadonlyGlobalsBlock = nfiContextExtension.getNativeFunction(context, "__sulong_protect_readonly_globals_block", "(POINTER):VOID");
        this.interop = (InteropLibrary)InteropLibrary.getFactory().create((Object)this.protectReadonlyGlobalsBlock);
    }

    @Override
    public void execute(LLVMPointer ptr) {
        block2: {
            try {
                this.interop.execute((Object)this.protectReadonlyGlobalsBlock, new Object[]{ptr});
            }
            catch (InteropException ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }
}

