/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDirectLoadNodeFactory;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMDirectLoadNode {

    public static abstract class LLVMStructDirectLoadNode
    extends LLVMLoadNode {
        @Specialization
        protected LLVMPointer doPointer(LLVMPointer addr) {
            return addr;
        }
    }

    @GenerateUncached
    public static abstract class LLVMPointerDirectLoadNode
    extends LLVMLoadNode {
        public static LLVMPointerDirectLoadNode create() {
            return LLVMDirectLoadNodeFactory.LLVMPointerDirectLoadNodeGen.create((LLVMExpressionNode)null);
        }

        @Specialization(guards={"!isAutoDerefHandle(language, addr)"})
        protected LLVMNativePointer doNativePointer(LLVMNativePointer addr, @CachedLanguage LLVMLanguage language) {
            return language.getLLVMMemory().getPointer((Node)this, addr);
        }

        @Specialization(guards={"isAutoDerefHandle(language, addr)"})
        protected LLVMPointer doDerefHandle(LLVMNativePointer addr, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLanguage LLVMLanguage language, @CachedLibrary(limit="3") LLVMManagedReadLibrary nativeRead) {
            return this.doIndirectedForeign(getReceiver.execute(addr), nativeRead);
        }

        @Specialization(limit="3")
        protected LLVMPointer doIndirectedForeign(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
            return nativeRead.readPointer(addr.getObject(), addr.getOffset());
        }
    }

    public static abstract class LLVM80BitFloatDirectLoadNode
    extends LLVMLoadNode {
        static LLVM80BitFloatDirectLoadNode create() {
            return LLVMDirectLoadNodeFactory.LLVM80BitFloatDirectLoadNodeGen.create((LLVMExpressionNode)null);
        }

        protected abstract LLVM80BitFloat executeManaged(LLVMManagedPointer var1);

        @Specialization(guards={"!isAutoDerefHandle(language, addr)"})
        protected LLVM80BitFloat do80BitFloatNative(LLVMNativePointer addr, @CachedLanguage LLVMLanguage language) {
            return language.getLLVMMemory().get80BitFloat(this, addr);
        }

        @Specialization(guards={"isAutoDerefHandle(language, addr)"})
        protected LLVM80BitFloat do80BitFloatDerefHandle(LLVMNativePointer addr, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLanguage LLVMLanguage language, @Cached LLVM80BitFloatDirectLoadNode load) {
            return load.executeManaged(getReceiver.execute(addr));
        }

        @ExplodeLoop
        @Specialization(limit="3")
        protected LLVM80BitFloat doForeign(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
            byte[] result = new byte[10];
            long curOffset = addr.getOffset();
            for (int i = 0; i < result.length; ++i) {
                result[i] = nativeRead.readI8(addr.getObject(), curOffset);
                ++curOffset;
            }
            return LLVM80BitFloat.fromBytes(result);
        }
    }

    @NodeField(name="bitWidth", type=int.class)
    public static abstract class LLVMIVarBitDirectLoadNode
    extends LLVMLoadNode {
        protected abstract LLVMIVarBit executeManaged(LLVMManagedPointer var1);

        public abstract int getBitWidth();

        @Specialization(guards={"!isAutoDerefHandle(language, addr)"})
        protected LLVMIVarBit doIVarBitNative(LLVMNativePointer addr, @CachedLanguage LLVMLanguage language) {
            return language.getLLVMMemory().getIVarBit(this, addr, this.getBitWidth());
        }

        LLVMIVarBitDirectLoadNode createRecursive() {
            return LLVMDirectLoadNodeFactory.LLVMIVarBitDirectLoadNodeGen.create(null, this.getBitWidth());
        }

        @Specialization(guards={"isAutoDerefHandle(language, addr)"})
        protected LLVMIVarBit doIVarBitDerefHandle(LLVMNativePointer addr, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLanguage LLVMLanguage language, @Cached(value="createRecursive()") LLVMIVarBitDirectLoadNode load) {
            return load.executeManaged(getReceiver.execute(addr));
        }

        @Specialization(limit="3")
        protected LLVMIVarBit doForeign(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
            byte[] result = new byte[this.getByteSize()];
            long curOffset = addr.getOffset();
            for (int i = result.length - 1; i >= 0; --i) {
                result[i] = nativeRead.readI8(addr.getObject(), curOffset);
                ++curOffset;
            }
            return LLVMIVarBit.create(this.getBitWidth(), result, this.getBitWidth(), false);
        }

        private int getByteSize() {
            assert (this.getBitWidth() % 8 == 0);
            return this.getBitWidth() / 8;
        }
    }
}

