/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.DoubleValueProfile;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDoubleLoadNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@GenerateUncached
public abstract class LLVMDoubleLoadNode
extends LLVMLoadNode {
    public static LLVMDoubleLoadNode create() {
        return LLVMDoubleLoadNodeGen.create((LLVMExpressionNode)null);
    }

    @Specialization(guards={"!isAutoDerefHandle(language, addr)"})
    protected double doDoubleNative(LLVMNativePointer addr, @Cached(value="createRawIdentityProfile()") DoubleValueProfile profile, @CachedLanguage LLVMLanguage language) {
        return profile.profile(language.getLLVMMemory().getDouble((Node)this, addr));
    }

    @Specialization(guards={"isAutoDerefHandle(language, addr)"})
    protected double doDoubleDerefHandle(LLVMNativePointer addr, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLanguage LLVMLanguage language, @CachedLibrary(limit="3") LLVMManagedReadLibrary nativeRead) {
        return this.doDoubleManaged(getReceiver.execute(addr), nativeRead);
    }

    @Specialization(limit="3")
    protected double doDoubleManaged(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
        return nativeRead.readDouble(addr.getObject(), addr.getOffset());
    }
}

