/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.IntValueProfile;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@GenerateUncached
public abstract class LLVMI32LoadNode
extends LLVMLoadNode {
    public static LLVMI32LoadNode create() {
        return LLVMI32LoadNodeGen.create((LLVMExpressionNode)null);
    }

    @Specialization(guards={"!isAutoDerefHandle(language, addr)"})
    protected int doI32Native(LLVMNativePointer addr, @Cached(value="createIdentityProfile()") IntValueProfile profile, @CachedLanguage LLVMLanguage language) {
        return profile.profile(language.getLLVMMemory().getI32((Node)this, addr));
    }

    @Specialization(guards={"isAutoDerefHandle(language, addr)"})
    protected int doI32DerefHandle(LLVMNativePointer addr, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLanguage LLVMLanguage language, @CachedLibrary(limit="3") LLVMManagedReadLibrary nativeRead) {
        return this.doI32Managed(getReceiver.execute(addr), nativeRead);
    }

    @Specialization(limit="3")
    protected int doI32Managed(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
        return nativeRead.readI32(addr.getObject(), addr.getOffset());
    }
}

