/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.LongValueProfile;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@GenerateUncached
public abstract class LLVMI64LoadNode
extends LLVMLoadNode {
    public static LLVMI64LoadNode create() {
        return LLVMI64LoadNodeGen.create((LLVMExpressionNode)null);
    }

    @Specialization(guards={"!isAutoDerefHandle(language, addr)"})
    protected long doI64Native(LLVMNativePointer addr, @Cached(value="createIdentityProfile()") LongValueProfile profile, @CachedLanguage LLVMLanguage language) {
        return profile.profile(language.getLLVMMemory().getI64((Node)this, addr));
    }

    @Specialization(guards={"isAutoDerefHandle(language, addr)"}, rewriteOn={UnexpectedResultException.class})
    protected long doI64DerefHandle(LLVMNativePointer addr, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLanguage LLVMLanguage language, @CachedLibrary(limit="3") LLVMManagedReadLibrary nativeRead) throws UnexpectedResultException {
        return this.doI64Managed(getReceiver.execute(addr), nativeRead);
    }

    @Specialization(guards={"isAutoDerefHandle(language, addr)"}, replaces={"doI64DerefHandle"})
    protected Object doGenericI64DerefHandle(LLVMNativePointer addr, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLanguage LLVMLanguage language, @CachedLibrary(limit="3") LLVMManagedReadLibrary nativeRead) {
        return this.doGenericI64Managed(getReceiver.execute(addr), nativeRead);
    }

    @Specialization(limit="3", rewriteOn={UnexpectedResultException.class})
    protected long doI64Managed(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) throws UnexpectedResultException {
        return nativeRead.readI64(addr.getObject(), addr.getOffset());
    }

    @Specialization(limit="3", replaces={"doI64Managed"})
    protected Object doGenericI64Managed(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
        return nativeRead.readGenericI64(addr.getObject(), addr.getOffset());
    }
}

