/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.rmw;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI8LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI8StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI8StoreNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class, value="pointerNode"), @NodeChild(type=LLVMExpressionNode.class, value="valueNode")})
public abstract class LLVMI8RMWNode
extends LLVMExpressionNode {
    protected static LLVMI8StoreNode createWrite() {
        return LLVMI8StoreNodeGen.create(null, null);
    }

    public static abstract class LLVMI8RMWXorNode
    extends LLVMI8RMWNode {
        @Specialization
        protected byte doOp(LLVMNativePointer address, byte value, @CachedLanguage LLVMLanguage language) {
            return language.getLLVMMemory().getAndOpI8(this, address, value, (a, b) -> (byte)(a ^ b));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected byte doOp(LLVMManagedPointer address, byte value, @Cached LLVMI8LoadNode read, @Cached(value="createWrite()") LLVMI8StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                byte result = (Byte)read.executeWithTarget(address);
                write.executeWithTarget(address, (byte)(result ^ value));
                return result;
            }
        }
    }

    public static abstract class LLVMI8RMWOrNode
    extends LLVMI8RMWNode {
        @Specialization
        protected byte doOp(LLVMNativePointer address, byte value, @CachedLanguage LLVMLanguage language) {
            return language.getLLVMMemory().getAndOpI8(this, address, value, (a, b) -> (byte)(a | b));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected byte doOp(LLVMManagedPointer address, byte value, @Cached LLVMI8LoadNode read, @Cached(value="createWrite()") LLVMI8StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                byte result = (Byte)read.executeWithTarget(address);
                write.executeWithTarget(address, (byte)(result | value));
                return result;
            }
        }
    }

    public static abstract class LLVMI8RMWNandNode
    extends LLVMI8RMWNode {
        @Specialization
        protected byte doOp(LLVMNativePointer address, byte value, @CachedLanguage LLVMLanguage language) {
            return language.getLLVMMemory().getAndOpI8(this, address, value, (a, b) -> (byte)(~(a & b)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected byte doOp(LLVMManagedPointer address, byte value, @Cached LLVMI8LoadNode read, @Cached(value="createWrite()") LLVMI8StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                byte result = (Byte)read.executeWithTarget(address);
                write.executeWithTarget(address, (byte)(~(result & value)));
                return result;
            }
        }
    }

    public static abstract class LLVMI8RMWAndNode
    extends LLVMI8RMWNode {
        @Specialization
        protected byte doOp(LLVMNativePointer address, byte value, @CachedLanguage LLVMLanguage language) {
            return language.getLLVMMemory().getAndOpI8(this, address, value, (a, b) -> (byte)(a & b));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected byte doOp(LLVMManagedPointer address, byte value, @Cached LLVMI8LoadNode read, @Cached(value="createWrite()") LLVMI8StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                byte result = (Byte)read.executeWithTarget(address);
                write.executeWithTarget(address, (byte)(result & value));
                return result;
            }
        }
    }

    public static abstract class LLVMI8RMWSubNode
    extends LLVMI8RMWNode {
        @Specialization
        protected byte doOp(LLVMNativePointer address, byte value, @CachedLanguage LLVMLanguage language) {
            return language.getLLVMMemory().getAndOpI8(this, address, value, (a, b) -> (byte)(a - b));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected byte doOp(LLVMManagedPointer address, byte value, @Cached LLVMI8LoadNode read, @Cached(value="createWrite()") LLVMI8StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                byte result = (Byte)read.executeWithTarget(address);
                write.executeWithTarget(address, (byte)(result - value));
                return result;
            }
        }
    }

    public static abstract class LLVMI8RMWAddNode
    extends LLVMI8RMWNode {
        @Specialization
        protected byte doOp(LLVMNativePointer address, byte value, @CachedLanguage LLVMLanguage language) {
            return language.getLLVMMemory().getAndOpI8(this, address, value, (a, b) -> (byte)(a + b));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected byte doOp(LLVMManagedPointer address, byte value, @Cached LLVMI8LoadNode read, @Cached(value="createWrite()") LLVMI8StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                byte result = (Byte)read.executeWithTarget(address);
                write.executeWithTarget(address, (byte)(result + value));
                return result;
            }
        }
    }

    public static abstract class LLVMI8RMWXchgNode
    extends LLVMI8RMWNode {
        @Specialization
        protected byte doOp(LLVMNativePointer address, byte value, @CachedLanguage LLVMLanguage language) {
            return language.getLLVMMemory().getAndOpI8(this, address, value, (a, b) -> b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected byte doOp(LLVMManagedPointer address, byte value, @Cached LLVMI8LoadNode read, @Cached(value="createWrite()") LLVMI8StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                byte result = (Byte)read.executeWithTarget(address);
                write.executeWithTarget(address, value);
                return result;
            }
        }
    }
}

