/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMStoreNodeCommon;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@GenerateUncached
public abstract class LLVMFloatStoreNode
extends LLVMStoreNodeCommon {
    @Specialization(guards={"!isAutoDerefHandle(language, addr)"})
    protected void doOp(LLVMNativePointer addr, float value, @CachedLanguage LLVMLanguage language) {
        language.getLLVMMemory().putFloat((Node)this, addr, value);
    }

    @Specialization(guards={"isAutoDerefHandle(language, addr)"})
    protected void doOpDerefHandle(LLVMNativePointer addr, float value, @CachedLanguage LLVMLanguage language, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLibrary(limit="3") LLVMManagedWriteLibrary nativeWrite) {
        this.doOpManaged(getReceiver.execute(addr), value, nativeWrite);
    }

    @Specialization(limit="3")
    protected void doOpManaged(LLVMManagedPointer address, float value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        nativeWrite.writeFloat(address.getObject(), address.getOffset(), value);
    }
}

