/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemMoveNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMStructStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMStructStoreNode.class)
public final class LLVMStructStoreNodeGen
extends LLVMStructStoreNode {
    private LLVMSourceLocation sourceLocation;
    private boolean statement;
    private final long structSize;
    @Node.Child
    private LLVMExpressionNode address_;
    @Node.Child
    private LLVMExpressionNode value_;
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_;
    @Node.Child
    private LLVMDerefHandleGetReceiverNode opDerefHandle_getReceiver_;
    @Node.Child
    private LLVMToNativeNode convert_toNative_;

    private LLVMStructStoreNodeGen(LLVMMemMoveNode memMove, LLVMExpressionNode address, LLVMExpressionNode value, long structSize) {
        super(memMove);
        this.structSize = structSize;
        this.address_ = address;
        this.value_ = value;
    }

    @Override
    public LLVMSourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public void setSourceLocation(LLVMSourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    @Override
    protected boolean isStatement() {
        return this.statement;
    }

    @Override
    protected void setStatement(boolean statement) {
        this.statement = statement;
    }

    @Override
    public long getStructSize() {
        return this.structSize;
    }

    @Override
    public void executeWithTarget(Object addressValue, Object valueValue) {
        LLVMPointer valueValue_;
        LLVMPointer addressValue_;
        int state = this.state_;
        if ((state & 1) != 0) {
            assert (this.getStructSize() == 0L);
            this.noCopy(addressValue, valueValue);
            return;
        }
        if ((state & 6) != 0 && LLVMTypes.isNativePointer(addressValue)) {
            addressValue_ = LLVMTypes.asNativePointer(addressValue);
            if (LLVMTypes.isNativePointer(valueValue)) {
                valueValue_ = LLVMTypes.asNativePointer(valueValue);
                if ((state & 2) != 0) {
                    TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__ = this.lLVMLanguageReference_;
                    LLVMLanguage op_language__ = (LLVMLanguage)lLVMLanguageReference__.get();
                    assert (this.getStructSize() > 0L);
                    if (!LLVMNode.isAutoDerefHandle(op_language__, addressValue_) && !LLVMNode.isAutoDerefHandle(op_language__, valueValue_)) {
                        this.doOp((LLVMNativePointer)addressValue_, (LLVMNativePointer)valueValue_, op_language__);
                        return;
                    }
                }
                if ((state & 4) != 0) {
                    TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__1 = this.lLVMLanguageReference_;
                    LLVMLanguage opDerefHandle_language__ = (LLVMLanguage)lLVMLanguageReference__1.get();
                    assert (this.getStructSize() > 0L);
                    if (LLVMNode.isAutoDerefHandle(opDerefHandle_language__, addressValue_) && LLVMNode.isAutoDerefHandle(opDerefHandle_language__, valueValue_)) {
                        this.doOpDerefHandle((LLVMNativePointer)addressValue_, (LLVMNativePointer)valueValue_, opDerefHandle_language__, this.opDerefHandle_getReceiver_);
                        return;
                    }
                }
            }
        }
        if ((state & 8) != 0 && LLVMTypes.isManagedPointer(addressValue)) {
            addressValue_ = LLVMTypes.asManagedPointer(addressValue);
            if (LLVMTypes.isManagedPointer(valueValue)) {
                valueValue_ = LLVMTypes.asManagedPointer(valueValue);
                assert (this.getStructSize() > 0L);
                this.doManaged((LLVMManagedPointer)addressValue_, (LLVMManagedPointer)valueValue_);
                return;
            }
        }
        if ((state & 0x10) != 0 && LLVMTypes.isNativePointer(addressValue)) {
            addressValue_ = LLVMTypes.asNativePointer(addressValue);
            if (LLVMTypes.isPointer(valueValue)) {
                valueValue_ = LLVMTypes.asPointer(valueValue);
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__2 = this.lLVMLanguageReference_;
                LLVMLanguage convert_language__ = (LLVMLanguage)lLVMLanguageReference__2.get();
                assert (this.getStructSize() > 0L);
                if (!LLVMNode.isAutoDerefHandle(convert_language__, addressValue_)) {
                    this.doConvert((LLVMNativePointer)addressValue_, valueValue_, convert_language__, this.convert_toNative_);
                    return;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(addressValue, valueValue);
    }

    @Override
    public void execute(VirtualFrame frameValue) {
        LLVMPointer valueValue__;
        LLVMPointer addressValue__;
        int state = this.state_;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        Object valueValue_ = this.value_.executeGeneric(frameValue);
        if ((state & 1) != 0) {
            assert (this.getStructSize() == 0L);
            this.noCopy(addressValue_, valueValue_);
            return;
        }
        if ((state & 6) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
            addressValue__ = LLVMTypes.asNativePointer(addressValue_);
            if (LLVMTypes.isNativePointer(valueValue_)) {
                valueValue__ = LLVMTypes.asNativePointer(valueValue_);
                if ((state & 2) != 0) {
                    TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__3 = this.lLVMLanguageReference_;
                    LLVMLanguage op_language__ = (LLVMLanguage)lLVMLanguageReference__3.get();
                    assert (this.getStructSize() > 0L);
                    if (!LLVMNode.isAutoDerefHandle(op_language__, addressValue__) && !LLVMNode.isAutoDerefHandle(op_language__, valueValue__)) {
                        this.doOp((LLVMNativePointer)addressValue__, (LLVMNativePointer)valueValue__, op_language__);
                        return;
                    }
                }
                if ((state & 4) != 0) {
                    TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__4 = this.lLVMLanguageReference_;
                    LLVMLanguage opDerefHandle_language__ = (LLVMLanguage)lLVMLanguageReference__4.get();
                    assert (this.getStructSize() > 0L);
                    if (LLVMNode.isAutoDerefHandle(opDerefHandle_language__, addressValue__) && LLVMNode.isAutoDerefHandle(opDerefHandle_language__, valueValue__)) {
                        this.doOpDerefHandle((LLVMNativePointer)addressValue__, (LLVMNativePointer)valueValue__, opDerefHandle_language__, this.opDerefHandle_getReceiver_);
                        return;
                    }
                }
            }
        }
        if ((state & 8) != 0 && LLVMTypes.isManagedPointer(addressValue_)) {
            addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
            if (LLVMTypes.isManagedPointer(valueValue_)) {
                valueValue__ = LLVMTypes.asManagedPointer(valueValue_);
                assert (this.getStructSize() > 0L);
                this.doManaged((LLVMManagedPointer)addressValue__, (LLVMManagedPointer)valueValue__);
                return;
            }
        }
        if ((state & 0x10) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
            addressValue__ = LLVMTypes.asNativePointer(addressValue_);
            if (LLVMTypes.isPointer(valueValue_)) {
                valueValue__ = LLVMTypes.asPointer(valueValue_);
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__5 = this.lLVMLanguageReference_;
                LLVMLanguage convert_language__ = (LLVMLanguage)lLVMLanguageReference__5.get();
                assert (this.getStructSize() > 0L);
                if (!LLVMNode.isAutoDerefHandle(convert_language__, addressValue__)) {
                    this.doConvert((LLVMNativePointer)addressValue__, valueValue__, convert_language__, this.convert_toNative_);
                    return;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(addressValue_, valueValue_);
    }

    private void executeAndSpecialize(Object addressValue, Object valueValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            LLVMPointer valueValue_;
            LLVMPointer addressValue_;
            if (this.getStructSize() == 0L) {
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                this.noCopy(addressValue, valueValue);
                return;
            }
            if (LLVMTypes.isNativePointer(addressValue)) {
                addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if (LLVMTypes.isNativePointer(valueValue)) {
                    valueValue_ = LLVMTypes.asNativePointer(valueValue);
                    LLVMLanguage op_language__ = null;
                    if (exclude == 0 && this.getStructSize() > 0L) {
                        TruffleLanguage.LanguageReference lLVMLanguageReference__6 = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__6 == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__6 = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        if (!LLVMNode.isAutoDerefHandle(op_language__ = (LLVMLanguage)lLVMLanguageReference__6.get(), addressValue_) && !LLVMNode.isAutoDerefHandle(op_language__, valueValue_)) {
                            this.state_ = state |= 2;
                            lock.unlock();
                            hasLock = false;
                            this.doOp((LLVMNativePointer)addressValue_, (LLVMNativePointer)valueValue_, op_language__);
                            return;
                        }
                    }
                    LLVMLanguage opDerefHandle_language__ = null;
                    if (this.getStructSize() > 0L) {
                        TruffleLanguage.LanguageReference lLVMLanguageReference__7 = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__7 == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__7 = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        if (LLVMNode.isAutoDerefHandle(opDerefHandle_language__ = (LLVMLanguage)lLVMLanguageReference__7.get(), addressValue_) && LLVMNode.isAutoDerefHandle(opDerefHandle_language__, valueValue_)) {
                            this.opDerefHandle_getReceiver_ = (LLVMDerefHandleGetReceiverNode)super.insert((Node)LLVMDerefHandleGetReceiverNodeGen.create());
                            this.state_ = state |= 4;
                            lock.unlock();
                            hasLock = false;
                            this.doOpDerefHandle((LLVMNativePointer)addressValue_, (LLVMNativePointer)valueValue_, opDerefHandle_language__, this.opDerefHandle_getReceiver_);
                            return;
                        }
                    }
                }
            }
            if (LLVMTypes.isManagedPointer(addressValue)) {
                addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if (LLVMTypes.isManagedPointer(valueValue)) {
                    valueValue_ = LLVMTypes.asManagedPointer(valueValue);
                    if (this.getStructSize() > 0L) {
                        this.state_ = state |= 8;
                        lock.unlock();
                        hasLock = false;
                        this.doManaged((LLVMManagedPointer)addressValue_, (LLVMManagedPointer)valueValue_);
                        return;
                    }
                }
            }
            LLVMLanguage convert_language__ = null;
            if (LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_2 = LLVMTypes.asNativePointer(addressValue);
                if (LLVMTypes.isPointer(valueValue)) {
                    LLVMPointer valueValue_2 = LLVMTypes.asPointer(valueValue);
                    if (this.getStructSize() > 0L) {
                        TruffleLanguage.LanguageReference lLVMLanguageReference__8 = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__8 == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__8 = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        if (!LLVMNode.isAutoDerefHandle(convert_language__ = (LLVMLanguage)lLVMLanguageReference__8.get(), addressValue_2)) {
                            this.convert_toNative_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNode.createToNativeWithTarget());
                            this.exclude_ = exclude |= 1;
                            state &= 0xFFFFFFFD;
                            this.state_ = state |= 0x10;
                            lock.unlock();
                            hasLock = false;
                            this.doConvert(addressValue_2, valueValue_2, convert_language__, this.convert_toNative_);
                            return;
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_, this.value_}, new Object[]{addressValue, valueValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMStructStoreNode create(LLVMMemMoveNode memMove, LLVMExpressionNode address, LLVMExpressionNode value, long structSize) {
        return new LLVMStructStoreNodeGen(memMove, address, value, structSize);
    }
}

